
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
/*
 * This class is generated using freemarker and the AggrTypeFunctions1.java template.
 */


package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;

@SuppressWarnings("unused")

public class MaxFunctions {
	static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(MaxFunctions.class);


@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntMax implements DrillAggFunc{

  @Param IntHolder in;
  @Workspace IntHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntHolder out;

  public void setup() {
	  value = new IntHolder();
	  nonNullCount = new BigIntHolder();
	  nonNullCount.value = 0;
	    value.value = Integer.MIN_VALUE;
	  
  }
  
  @Override
  public void add() {
    nonNullCount.value = 1;
	    value.value = Math.max(value.value,  in.value);
  }

  @Override
  public void output() {   
    if (nonNullCount.value > 0) {
      out.value = value.value;
      out.isSet = 1;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
	    value.value = Integer.MIN_VALUE;
	  
  }
 
 }


@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class BigIntMax implements DrillAggFunc{

  @Param BigIntHolder in;
  @Workspace BigIntHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableBigIntHolder out;

  public void setup() {
	  value = new BigIntHolder();
	  nonNullCount = new BigIntHolder();
	  nonNullCount.value = 0;
	    value.value = Long.MIN_VALUE;
	  
  }
  
  @Override
  public void add() {
    nonNullCount.value = 1;
	    value.value = Math.max(value.value,  in.value);
  }

  @Override
  public void output() {   
    if (nonNullCount.value > 0) {
      out.value = value.value;
      out.isSet = 1;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
	    value.value = Long.MIN_VALUE;
	  
  }
 
 }


@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntMax implements DrillAggFunc{

  @Param NullableIntHolder in;
  @Workspace IntHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntHolder out;

  public void setup() {
	  value = new IntHolder();
	  nonNullCount = new BigIntHolder();
	  nonNullCount.value = 0;
	    value.value = Integer.MIN_VALUE;
	  
  }
  
  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    nonNullCount.value = 1;
	    value.value = Math.max(value.value,  in.value);
    } // end of sout block
  }

  @Override
  public void output() {   
    if (nonNullCount.value > 0) {
      out.value = value.value;
      out.isSet = 1;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
	    value.value = Integer.MIN_VALUE;
	  
  }
 
 }


@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableBigIntMax implements DrillAggFunc{

  @Param NullableBigIntHolder in;
  @Workspace BigIntHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableBigIntHolder out;

  public void setup() {
	  value = new BigIntHolder();
	  nonNullCount = new BigIntHolder();
	  nonNullCount.value = 0;
	    value.value = Long.MIN_VALUE;
	  
  }
  
  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    nonNullCount.value = 1;
	    value.value = Math.max(value.value,  in.value);
    } // end of sout block
  }

  @Override
  public void output() {   
    if (nonNullCount.value > 0) {
      out.value = value.value;
      out.isSet = 1;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
	    value.value = Long.MIN_VALUE;
	  
  }
 
 }


@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class Float4Max implements DrillAggFunc{

  @Param Float4Holder in;
  @Workspace Float4Holder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat4Holder out;

  public void setup() {
	  value = new Float4Holder();
	  nonNullCount = new BigIntHolder();
	  nonNullCount.value = 0;
		value.value = -Float.MAX_VALUE;
	  
  }
  
  @Override
  public void add() {
    nonNullCount.value = 1;
	    value.value = Math.max(value.value,  in.value);
  }

  @Override
  public void output() {   
    if (nonNullCount.value > 0) {
      out.value = value.value;
      out.isSet = 1;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
		value.value = -Float.MAX_VALUE;
	  
  }
 
 }


@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class Float8Max implements DrillAggFunc{

  @Param Float8Holder in;
  @Workspace Float8Holder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
	  value = new Float8Holder();
	  nonNullCount = new BigIntHolder();
	  nonNullCount.value = 0;
		value.value = -Double.MAX_VALUE;
	  
  }
  
  @Override
  public void add() {
    nonNullCount.value = 1;
	    value.value = Math.max(value.value,  in.value);
  }

  @Override
  public void output() {   
    if (nonNullCount.value > 0) {
      out.value = value.value;
      out.isSet = 1;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
		value.value = -Double.MAX_VALUE;
	  
  }
 
 }


@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableFloat4Max implements DrillAggFunc{

  @Param NullableFloat4Holder in;
  @Workspace Float4Holder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat4Holder out;

  public void setup() {
	  value = new Float4Holder();
	  nonNullCount = new BigIntHolder();
	  nonNullCount.value = 0;
		value.value = -Float.MAX_VALUE;
	  
  }
  
  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    nonNullCount.value = 1;
	    value.value = Math.max(value.value,  in.value);
    } // end of sout block
  }

  @Override
  public void output() {   
    if (nonNullCount.value > 0) {
      out.value = value.value;
      out.isSet = 1;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
		value.value = -Float.MAX_VALUE;
	  
  }
 
 }


@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableFloat8Max implements DrillAggFunc{

  @Param NullableFloat8Holder in;
  @Workspace Float8Holder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
	  value = new Float8Holder();
	  nonNullCount = new BigIntHolder();
	  nonNullCount.value = 0;
		value.value = -Double.MAX_VALUE;
	  
  }
  
  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    nonNullCount.value = 1;
	    value.value = Math.max(value.value,  in.value);
    } // end of sout block
  }

  @Override
  public void output() {   
    if (nonNullCount.value > 0) {
      out.value = value.value;
      out.isSet = 1;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
		value.value = -Double.MAX_VALUE;
	  
  }
 
 }

}
