
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;

/*
 * This class is generated using freemarker and the DateIntervalFunctionTemplates/Extract.java template.
 */

public class GExtract {

  @FunctionTemplate(name = "extractSecond", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class SecondFromDate implements DrillSimpleFunc {

    @Param DateHolder in;
    @Output Float8Holder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
      dateTime.setMillis(in.value);

      out.value = dateTime.getSecondOfMinute();
      out.value += ((double) dateTime.getMillisOfSecond()) / 1000;
    }
  }
  @FunctionTemplate(name = "extractMinute", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class MinuteFromDate implements DrillSimpleFunc {

    @Param DateHolder in;
    @Output BigIntHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
      dateTime.setMillis(in.value);

      out.value = dateTime.getMinuteOfHour();
    }
  }
  @FunctionTemplate(name = "extractHour", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class HourFromDate implements DrillSimpleFunc {

    @Param DateHolder in;
    @Output BigIntHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
      dateTime.setMillis(in.value);

      out.value = dateTime.getHourOfDay();
    }
  }
  @FunctionTemplate(name = "extractDay", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class DayFromDate implements DrillSimpleFunc {

    @Param DateHolder in;
    @Output BigIntHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
      dateTime.setMillis(in.value);

      out.value = dateTime.getDayOfMonth();
    }
  }
  @FunctionTemplate(name = "extractMonth", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class MonthFromDate implements DrillSimpleFunc {

    @Param DateHolder in;
    @Output BigIntHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
      dateTime.setMillis(in.value);

      out.value = dateTime.getMonthOfYear();
    }
  }
  @FunctionTemplate(name = "extractYear", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class YearFromDate implements DrillSimpleFunc {

    @Param DateHolder in;
    @Output BigIntHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
      dateTime.setMillis(in.value);

      out.value = dateTime.getYear();
    }
  }
  @FunctionTemplate(name = "extractSecond", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class SecondFromTime implements DrillSimpleFunc {

    @Param TimeHolder in;
    @Output Float8Holder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
      dateTime.setMillis(in.value);

      out.value = dateTime.getSecondOfMinute();
      out.value += ((double) dateTime.getMillisOfSecond()) / 1000;
    }
  }
  @FunctionTemplate(name = "extractMinute", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class MinuteFromTime implements DrillSimpleFunc {

    @Param TimeHolder in;
    @Output BigIntHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
      dateTime.setMillis(in.value);

      out.value = dateTime.getMinuteOfHour();
    }
  }
  @FunctionTemplate(name = "extractHour", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class HourFromTime implements DrillSimpleFunc {

    @Param TimeHolder in;
    @Output BigIntHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
      dateTime.setMillis(in.value);

      out.value = dateTime.getHourOfDay();
    }
  }
  @FunctionTemplate(name = "extractSecond", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class SecondFromTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder in;
    @Output Float8Holder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
      dateTime.setMillis(in.value);

      out.value = dateTime.getSecondOfMinute();
      out.value += ((double) dateTime.getMillisOfSecond()) / 1000;
    }
  }
  @FunctionTemplate(name = "extractMinute", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class MinuteFromTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder in;
    @Output BigIntHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
      dateTime.setMillis(in.value);

      out.value = dateTime.getMinuteOfHour();
    }
  }
  @FunctionTemplate(name = "extractHour", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class HourFromTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder in;
    @Output BigIntHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
      dateTime.setMillis(in.value);

      out.value = dateTime.getHourOfDay();
    }
  }
  @FunctionTemplate(name = "extractDay", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class DayFromTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder in;
    @Output BigIntHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
      dateTime.setMillis(in.value);

      out.value = dateTime.getDayOfMonth();
    }
  }
  @FunctionTemplate(name = "extractMonth", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class MonthFromTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder in;
    @Output BigIntHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
      dateTime.setMillis(in.value);

      out.value = dateTime.getMonthOfYear();
    }
  }
  @FunctionTemplate(name = "extractYear", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class YearFromTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder in;
    @Output BigIntHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
      dateTime.setMillis(in.value);

      out.value = dateTime.getYear();
    }
  }
  @FunctionTemplate(name = "extractSecond", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class SecondFromInterval implements DrillSimpleFunc {

    @Param IntervalHolder in;
    @Output Float8Holder out;

    public void setup() { }

    public void eval() {
      long millis = in.milliseconds % org.apache.drill.exec.expr.fn.impl.DateUtility.minutesToMillis;
      out.value = (double) millis / (org.apache.drill.exec.expr.fn.impl.DateUtility.secondsToMillis);
    }
  }
  @FunctionTemplate(name = "extractMinute", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class MinuteFromInterval implements DrillSimpleFunc {

    @Param IntervalHolder in;
    @Output BigIntHolder out;

    public void setup() { }

    public void eval() {
      int millis = in.milliseconds % (org.apache.drill.exec.expr.fn.impl.DateUtility.hoursToMillis);
      out.value = millis / (org.apache.drill.exec.expr.fn.impl.DateUtility.minutesToMillis);
    }
  }
  @FunctionTemplate(name = "extractHour", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class HourFromInterval implements DrillSimpleFunc {

    @Param IntervalHolder in;
    @Output BigIntHolder out;

    public void setup() { }

    public void eval() {
      out.value = in.milliseconds/(org.apache.drill.exec.expr.fn.impl.DateUtility.hoursToMillis);
    }
  }
  @FunctionTemplate(name = "extractDay", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class DayFromInterval implements DrillSimpleFunc {

    @Param IntervalHolder in;
    @Output BigIntHolder out;

    public void setup() { }

    public void eval() {
      out.value = in.days;
    }
  }
  @FunctionTemplate(name = "extractMonth", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class MonthFromInterval implements DrillSimpleFunc {

    @Param IntervalHolder in;
    @Output BigIntHolder out;

    public void setup() { }

    public void eval() {
      out.value = (in.months % org.apache.drill.exec.expr.fn.impl.DateUtility.yearsToMonths);
    }
  }
  @FunctionTemplate(name = "extractYear", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class YearFromInterval implements DrillSimpleFunc {

    @Param IntervalHolder in;
    @Output BigIntHolder out;

    public void setup() { }

    public void eval() {
      out.value = (in.months / org.apache.drill.exec.expr.fn.impl.DateUtility.yearsToMonths);
    }
  }
  @FunctionTemplate(name = "extractSecond", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class SecondFromIntervalDay implements DrillSimpleFunc {

    @Param IntervalDayHolder in;
    @Output Float8Holder out;

    public void setup() { }

    public void eval() {
      long millis = in.milliseconds % org.apache.drill.exec.expr.fn.impl.DateUtility.minutesToMillis;
      out.value = (double) millis / (org.apache.drill.exec.expr.fn.impl.DateUtility.secondsToMillis);
      }
  }
  @FunctionTemplate(name = "extractMinute", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class MinuteFromIntervalDay implements DrillSimpleFunc {

    @Param IntervalDayHolder in;
    @Output BigIntHolder out;

    public void setup() { }

    public void eval() {
      int millis = in.milliseconds % (org.apache.drill.exec.expr.fn.impl.DateUtility.hoursToMillis);
      out.value = millis / (org.apache.drill.exec.expr.fn.impl.DateUtility.minutesToMillis);
      }
  }
  @FunctionTemplate(name = "extractHour", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class HourFromIntervalDay implements DrillSimpleFunc {

    @Param IntervalDayHolder in;
    @Output BigIntHolder out;

    public void setup() { }

    public void eval() {
      out.value = in.milliseconds/(org.apache.drill.exec.expr.fn.impl.DateUtility.hoursToMillis);
      }
  }
  @FunctionTemplate(name = "extractDay", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class DayFromIntervalDay implements DrillSimpleFunc {

    @Param IntervalDayHolder in;
    @Output BigIntHolder out;

    public void setup() { }

    public void eval() {
      out.value = in.days;
      }
  }
  @FunctionTemplate(name = "extractMonth", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class MonthFromIntervalDay implements DrillSimpleFunc {

    @Param IntervalDayHolder in;
    @Output BigIntHolder out;

    public void setup() { }

    public void eval() {
      out.value = 0;
      }
  }
  @FunctionTemplate(name = "extractYear", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class YearFromIntervalDay implements DrillSimpleFunc {

    @Param IntervalDayHolder in;
    @Output BigIntHolder out;

    public void setup() { }

    public void eval() {
      out.value = 0;
      }
  }
  @FunctionTemplate(name = "extractSecond", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class SecondFromIntervalYear implements DrillSimpleFunc {

    @Param IntervalYearHolder in;
    @Output Float8Holder out;

    public void setup() { }

    public void eval() {
 
      out.value = 0;
    }
  }
  @FunctionTemplate(name = "extractMinute", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class MinuteFromIntervalYear implements DrillSimpleFunc {

    @Param IntervalYearHolder in;
    @Output BigIntHolder out;

    public void setup() { }

    public void eval() {
 
      out.value = 0;
    }
  }
  @FunctionTemplate(name = "extractHour", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class HourFromIntervalYear implements DrillSimpleFunc {

    @Param IntervalYearHolder in;
    @Output BigIntHolder out;

    public void setup() { }

    public void eval() {
 
      out.value = 0;
    }
  }
  @FunctionTemplate(name = "extractDay", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class DayFromIntervalYear implements DrillSimpleFunc {

    @Param IntervalYearHolder in;
    @Output BigIntHolder out;

    public void setup() { }

    public void eval() {
 
      out.value = 0;
    }
  }
  @FunctionTemplate(name = "extractMonth", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class MonthFromIntervalYear implements DrillSimpleFunc {

    @Param IntervalYearHolder in;
    @Output BigIntHolder out;

    public void setup() { }

    public void eval() {
 
      out.value = (in.value % org.apache.drill.exec.expr.fn.impl.DateUtility.yearsToMonths);
    }
  }
  @FunctionTemplate(name = "extractYear", scope = FunctionTemplate.FunctionScope.SIMPLE,
      nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class YearFromIntervalYear implements DrillSimpleFunc {

    @Param IntervalYearHolder in;
    @Output BigIntHolder out;

    public void setup() { }

    public void eval() {
 
      out.value = (in.value / org.apache.drill.exec.expr.fn.impl.DateUtility.yearsToMonths);
    }
  }
}