/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.test;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.drill.common.util.RepeatTestRule;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class TestTools {
    public static final Path TEST_RESOURCES_REL = Paths.get("src", "test", "resources");
    public static final Path PROJECT_ROOT = Paths.get("..", "..");
    public static final Path WORKING_PATH = new File(".").toPath();
    public static final Path TEST_RESOURCES_ABS = WORKING_PATH.resolve(TEST_RESOURCES_REL);
    public static final Path SAMPLE_DATA = PROJECT_ROOT.resolve("sample-data");
    static final boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;

    public static TestRule getTimeoutRule(int timeout) {
        return IS_DEBUG ? new TestName() : Timeout.millis((long)timeout);
    }

    public static TestRule getRepeatRule(boolean enforce) {
        return enforce || !IS_DEBUG ? new RepeatTestRule() : new TestName();
    }

    public static File getResourceFile(Path relPath) {
        return WORKING_PATH.resolve(TEST_RESOURCES_REL).resolve(relPath).toFile();
    }

    public static File getProjectFile(Path relPath) {
        return WORKING_PATH.resolve(PROJECT_ROOT).resolve(relPath).toFile();
    }

    public static File getFile(Path relPath, FileSource fileSource) {
        switch (fileSource.ordinal()) {
            case 0: {
                return TestTools.getResourceFile(relPath);
            }
            case 1: {
                return TestTools.getProjectFile(relPath);
            }
        }
        throw new IllegalArgumentException(String.format("Unkown data type %s", new Object[]{fileSource}));
    }

    public static void copyDirToDest(Path relPath, File destDir, FileSource fileSource) {
        File srcDir;
        switch (fileSource.ordinal()) {
            case 0: {
                srcDir = TestTools.getResourceFile(relPath);
                break;
            }
            case 1: {
                srcDir = TestTools.getProjectFile(relPath);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unkown data type %s", new Object[]{fileSource}));
            }
        }
        try {
            FileUtils.copyDirectory((File)srcDir, (File)destDir);
        }
        catch (IOException e) {
            throw new RuntimeException("This should never happen", e);
        }
    }

    public static enum FileSource {
        RESOURCE,
        PROJECT;

    }
}

