/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.List;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.test.BaseTest;
import org.apache.drill.test.TestTools;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillTest
extends BaseTest {
    private static final ObjectMapper objectMapper = JacksonUtils.createObjectMapper();
    static final SystemManager manager;
    static final Logger testReporter;
    static final TestLogReporter LOG_OUTCOME;
    static MemWatcher memWatcher;
    static String className;
    @Rule
    public final TestRule TIMEOUT = new DisableOnDebug(TestTools.getTimeoutRule(1000000));
    @Rule
    public final TestLogReporter logOutcome = LOG_OUTCOME;
    @Rule
    public final TestRule REPEAT_RULE = TestTools.getRepeatRule(false);

    @BeforeClass
    public static void initDrillTest() {
        memWatcher = new MemWatcher();
    }

    @AfterClass
    public static void finishDrillTest() {
        testReporter.info(String.format("Test Class done (%s): %s.", memWatcher.getMemString(true), className));
        Thread.interrupted();
    }

    public static String escapeJsonString(String original) {
        try {
            return objectMapper.writeValueAsString((Object)original);
        }
        catch (JsonProcessingException e) {
            return original;
        }
    }

    static {
        System.setProperty("line.separator", "\n");
        manager = new SystemManager();
        testReporter = LoggerFactory.getLogger((String)"org.apache.drill.TestReporter");
        LOG_OUTCOME = new TestLogReporter();
    }

    private static class TestLogReporter
    extends TestWatcher {
        private MemWatcher memWatcher;

        private TestLogReporter() {
        }

        protected void starting(Description description) {
            super.starting(description);
            className = description.getClassName();
            this.memWatcher = new MemWatcher();
        }

        protected void failed(Throwable e, Description description) {
            testReporter.error(String.format("Test Failed (%s): %s", this.memWatcher.getMemString(), description.getDisplayName()), e);
        }

        public void succeeded(Description description) {
            testReporter.info(String.format("Test Succeeded (%s): %s", this.memWatcher.getMemString(), description.getDisplayName()));
        }
    }

    protected static class MemWatcher {
        private long startDirect = manager.getMemDirect();
        private long startHeap = manager.getMemHeap();
        private long startNonHeap = manager.getMemNonHeap();

        public Object getMemString() {
            return this.getMemString(false);
        }

        public String getMemString(boolean runGC) {
            if (runGC) {
                Runtime.getRuntime().gc();
            }
            long endDirect = manager.getMemDirect();
            long endHeap = manager.getMemHeap();
            long endNonHeap = manager.getMemNonHeap();
            return String.format("d: %s(%s), h: %s(%s), nh: %s(%s)", DrillStringUtils.readable((long)(endDirect - this.startDirect)), DrillStringUtils.readable((long)endDirect), DrillStringUtils.readable((long)(endHeap - this.startHeap)), DrillStringUtils.readable((long)endHeap), DrillStringUtils.readable((long)(endNonHeap - this.startNonHeap)), DrillStringUtils.readable((long)endNonHeap));
        }
    }

    private static class SystemManager {
        final BufferPoolMXBean directBean;
        final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();

        public SystemManager() {
            BufferPoolMXBean localBean = null;
            List<BufferPoolMXBean> pools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
            for (BufferPoolMXBean b : pools) {
                if (!b.getName().equals("direct")) continue;
                localBean = b;
            }
            this.directBean = localBean;
        }

        public long getMemDirect() {
            return this.directBean.getMemoryUsed();
        }

        public long getMemHeap() {
            return this.memoryBean.getHeapMemoryUsage().getUsed();
        }

        public long getMemNonHeap() {
            return this.memoryBean.getNonHeapMemoryUsage().getUsed();
        }
    }
}

