/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.test;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class DirTestWatcher
extends TestWatcher {
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    private String dirPath;
    private File dir;
    private boolean deleteDirAtEnd = true;

    public DirTestWatcher() {
    }

    public DirTestWatcher(boolean deleteDirAtEnd) {
        this.deleteDirAtEnd = deleteDirAtEnd;
    }

    protected void starting(Description description) {
        this.dirPath = description.getMethodName() != null ? Paths.get(".", "target", description.getClassName(), description.getMethodName()).toString() : Paths.get(".", "target", description.getClassName()).toString();
        this.dir = new File(this.dirPath);
        FileUtils.deleteQuietly((File)this.dir);
        this.dir.mkdirs();
    }

    protected void finished(Description description) {
        this.deleteDir();
    }

    protected void failed(Throwable e, Description description) {
        this.deleteDir();
    }

    public File makeSubDir(Path relativeDirPath) {
        File subDir = this.dir.toPath().resolve(relativeDirPath).toFile();
        subDir.mkdirs();
        return subDir;
    }

    private void deleteDir() {
        if (this.deleteDirAtEnd) {
            FileUtils.deleteQuietly((File)this.dir);
        }
    }

    public File getDir() {
        return this.dir;
    }

    public static File createTempDir(File baseDir) {
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdirs()) continue;
            return tempDir;
        }
        String message = String.format("Failed to create directory within %s attempts (tried %s0 to %s)", 10000, baseName, baseName + "9999");
        throw new IllegalStateException(message);
    }
}

