/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.drill.common.logical.AbstractSecuredStoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.exec.store.security.CredentialProviderUtils;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;

@JsonTypeName(value="elastic")
public class ElasticsearchStorageConfig
extends AbstractSecuredStoragePluginConfig {
    public static final String NAME = "elastic";
    private static final ObjectWriter OBJECT_WRITER = new ObjectMapper().writerFor(List.class);
    private final List<String> hosts;

    @JsonCreator
    public ElasticsearchStorageConfig(@JsonProperty(value="hosts") List<String> hosts, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="credentialsProvider") CredentialsProvider credentialsProvider) {
        super(CredentialProviderUtils.getCredentialsProvider((String)username, (String)password, (CredentialsProvider)credentialsProvider), credentialsProvider == null);
        this.hosts = hosts;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public String getUsername() {
        if (this.directCredentials) {
            return this.getUsernamePasswordCredentials().getUsername();
        }
        return null;
    }

    public String getPassword() {
        if (this.directCredentials) {
            return this.getUsernamePasswordCredentials().getPassword();
        }
        return null;
    }

    @JsonIgnore
    public UsernamePasswordCredentials getUsernamePasswordCredentials() {
        return new UsernamePasswordCredentials(this.credentialsProvider);
    }

    @JsonIgnore
    public Map<String, Object> toConfigMap() throws JsonProcessingException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"hosts", (Object)OBJECT_WRITER.writeValueAsString(this.hosts));
        builder.putAll(this.credentialsProvider.getCredentials());
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ElasticsearchStorageConfig that = (ElasticsearchStorageConfig)((Object)o);
        return Objects.equals(this.hosts, that.hosts) && Objects.equals(this.credentialsProvider, that.credentialsProvider);
    }

    public int hashCode() {
        return Objects.hash(this.hosts, this.credentialsProvider);
    }
}

