/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.httpd;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import org.apache.drill.categories.RowSetTests;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.store.httpd.HttpdLogFormatConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RowSetTests.class})
public class TestHTTPDLogReaderUserAgent
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        dirTestWatcher.copyResourceToRoot(Paths.get("httpd/", new String[0]));
        TestHTTPDLogReaderUserAgent.defineHttpdPlugin();
    }

    private static void defineHttpdPlugin() {
        HashMap<String, HttpdLogFormatConfig> formats = new HashMap<String, HttpdLogFormatConfig>();
        formats.put("multiformat", new HttpdLogFormatConfig(Collections.singletonList("access_log"), "combined\ncommon\n%h %l %u %t \"%r\" %s %b \"%{Referer}i\"\n%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-agent}i\"\n%%%h %a %A %l %u %t \"%r\" %>s %b %p \"%q\" \"%!200,304,302{Referer}i\" %D \"%200{User-agent}i\" \"%{Cookie}i\" \"%{Set-Cookie}o\" \"%{If-None-Match}i\" \"%{Etag}o\"\n", null, 0, true, true, null));
        cluster.defineFormats("cp", formats);
    }

    @Test
    public void testMultiFormatUserAgent() throws RpcException {
        String sql = "SELECT                                                                 `request_receive_time_epoch`,                                `request_user-agent`,                                        `request_user-agent_device__name`,                           `request_user-agent_agent__name__version__major`   FROM   cp.`httpd/multiformat.access_log`                     ";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("request_receive_time_epoch", TypeProtos.MinorType.TIMESTAMP).addNullable("request_user-agent", TypeProtos.MinorType.VARCHAR).addNullable("request_user-agent_device__name", TypeProtos.MinorType.VARCHAR).addNullable("request_user-agent_agent__name__version__major", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{1356994180000L, "Mozilla/5.0 (X11; Linux i686 on x86_64; rv:11.0) Gecko/20100101 Firefox/11.0", "Linux Desktop", "Firefox 11"}).addRow(new Object[]{1356994181000L, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.139 Safari/537.36", "Apple Macintosh", "Chrome 66"}).addRow(new Object[]{1388530181000L, null, null, null}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testUserAgentEnabled() throws Exception {
        String sql = "SELECT                                                                         `request_receive_time_epoch`,                                `request_user-agent`,                                        `request_user-agent_device__name`,                           `request_user-agent_agent__name__version__major`   FROM       table(                                                         cp.`httpd/typeremap.log`                                         (                                                              type => 'httpd',                                             logFormat => 'common\ncombined\n%h %l %u %t \"%r\" %>s %b %{RequestId}o\n',\n                   flattenWildcards => true,                                    parseUserAgent => true                                     )                                                      )                                                 ";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("request_receive_time_epoch", TypeProtos.MinorType.TIMESTAMP).addNullable("request_user-agent", TypeProtos.MinorType.VARCHAR).addNullable("request_user-agent_device__name", TypeProtos.MinorType.VARCHAR).addNullable("request_user-agent_agent__name__version__major", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{1388530181000L, "Mozilla/5.0 (compatible; Googlebot/2.1; Yauaa Bot/42.123; +https://yauaa.basjes.nl)", "Basjes Googlebot Imitator", "Yauaa Bot 42"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testUserAgentDisabled() throws Exception {
        String sql = "SELECT                                                                         `request_receive_time_epoch`,                                `request_user-agent`,                                        `request_user-agent_device__name`,                           `request_user-agent_agent__name__version__major`   FROM       table(                                                         cp.`httpd/typeremap.log`                                         (                                                              type => 'httpd',                                             logFormat => 'common\ncombined\n%h %l %u %t \"%r\" %>s %b %{RequestId}o\n',\n                   flattenWildcards => true                                   )                                                      )                                                 LIMIT 1                                                      ";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("request_receive_time_epoch", TypeProtos.MinorType.TIMESTAMP).addNullable("request_user-agent", TypeProtos.MinorType.VARCHAR).addNullable("request_user-agent_device__name", TypeProtos.MinorType.VARCHAR).addNullable("request_user-agent_agent__name__version__major", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{1388530181000L, "Mozilla/5.0 (compatible; Googlebot/2.1; Yauaa Bot/42.123; +https://yauaa.basjes.nl)", null, null}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testUserAgentAndTypeRemapping() throws Exception {
        String sql = "SELECT                                                                           \n          `request_receive_time_epoch`                                           \n        , `request_user-agent`                                                   \n        , `request_user-agent_device__name`                                      \n        , `request_user-agent_agent__name__version__major`                       \n        , `request_firstline_uri_query_timestamp`                                \n        , `request_firstline_uri_query_ua`                                       \n        , `request_firstline_uri_query_ua_device__name`                          \n        , `request_firstline_uri_query_ua_agent__name__version__major`           \n        , `response_header_requestid_epoch`                                      \nFROM       table(                                                                \n             cp.`httpd/typeremap.log`                                            \n                 (                                                               \n                   type => 'httpd',                                              \n                   logFormat => 'common\ncombined\n%h %l %u %t \"%r\" %>s %b %{RequestId}o\n',\n                   flattenWildcards => true,                                     \n                   parseUserAgent => true,                                       \n                   logParserRemapping => '                                       \n                       request.firstline.uri.query.ua        :HTTP.USERAGENT ;   \n                       response.header.requestid             :MOD_UNIQUE_ID  ;   \n                       request.firstline.uri.query.timestamp :TIME.EPOCH : LONG  \n                   '                                                             \n                 )                                                               \n           )                                                                     \n";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        results.print();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("request_receive_time_epoch", TypeProtos.MinorType.TIMESTAMP).addNullable("request_user-agent", TypeProtos.MinorType.VARCHAR).addNullable("request_user-agent_device__name", TypeProtos.MinorType.VARCHAR).addNullable("request_user-agent_agent__name__version__major", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_uri_query_timestamp", TypeProtos.MinorType.TIMESTAMP).addNullable("request_firstline_uri_query_ua", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_uri_query_ua_device__name", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_uri_query_ua_agent__name__version__major", TypeProtos.MinorType.VARCHAR).addNullable("response_header_requestid_epoch", TypeProtos.MinorType.TIMESTAMP).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{1388530181000L, "Mozilla/5.0 (compatible; Googlebot/2.1; Yauaa Bot/42.123; +https://yauaa.basjes.nl)", "Basjes Googlebot Imitator", "Yauaa Bot 42", 1607506430621L, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.139 Safari/537.36", "Apple Macintosh", "Chrome 66", null}).addRow(new Object[]{1388530181000L, null, null, null, 1607506430621L, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3359.139 Safari/537.36", "Apple Macintosh", "Chrome 77", 1372024799000L}).addRow(new Object[]{1388530181000L, null, null, null, 1607506430621L, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.3359.139 Safari/537.36", "Apple Macintosh", "Chrome 55", null}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }
}

