/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.exception.StorageOperateNoConfiguredException;
import org.apache.dolphinscheduler.common.storage.StorageOperate;
import org.apache.dolphinscheduler.common.utils.CommonUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskChannel;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContextCacheManager;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskAlertInfo;
import org.apache.dolphinscheduler.server.utils.ProcessUtils;
import org.apache.dolphinscheduler.server.worker.processor.TaskCallbackService;
import org.apache.dolphinscheduler.service.alert.AlertClientService;
import org.apache.dolphinscheduler.service.exceptions.ServiceException;
import org.apache.dolphinscheduler.service.task.TaskPluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecuteThread
implements Runnable,
Delayed {
    private final Logger logger = LoggerFactory.getLogger(TaskExecuteThread.class);
    private TaskExecutionContext taskExecutionContext;
    private StorageOperate storageOperate;
    private AbstractTask task;
    private TaskCallbackService taskCallbackService;
    private AlertClientService alertClientService;
    private TaskPluginManager taskPluginManager;

    public StorageOperate getStorageOperate() {
        return this.storageOperate;
    }

    public void setStorageOperate(StorageOperate storageOperate) {
        this.storageOperate = storageOperate;
    }

    public TaskExecuteThread(TaskExecutionContext taskExecutionContext, TaskCallbackService taskCallbackService, AlertClientService alertClientService) {
        this.taskExecutionContext = taskExecutionContext;
        this.taskCallbackService = taskCallbackService;
        this.alertClientService = alertClientService;
    }

    public TaskExecuteThread(TaskExecutionContext taskExecutionContext, TaskCallbackService taskCallbackService, AlertClientService alertClientService, TaskPluginManager taskPluginManager) {
        this.taskExecutionContext = taskExecutionContext;
        this.taskCallbackService = taskCallbackService;
        this.alertClientService = alertClientService;
        this.taskPluginManager = taskPluginManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (1 == this.taskExecutionContext.getDryRun()) {
            this.taskExecutionContext.setCurrentExecutionStatus(ExecutionStatus.SUCCESS);
            this.taskExecutionContext.setStartTime(new Date());
            this.taskExecutionContext.setEndTime(new Date());
            TaskExecutionContextCacheManager.removeByTaskInstanceId((Integer)this.taskExecutionContext.getTaskInstanceId());
            this.taskCallbackService.sendTaskExecuteResponseCommand(this.taskExecutionContext);
            return;
        }
        try {
            this.logger.info("script path : {}", (Object)this.taskExecutionContext.getExecutePath());
            if (this.taskExecutionContext.getStartTime() == null) {
                this.taskExecutionContext.setStartTime(new Date());
            }
            this.logger.info("the task begins to execute. task instance id: {}", (Object)this.taskExecutionContext.getTaskInstanceId());
            this.taskExecutionContext.setCurrentExecutionStatus(ExecutionStatus.RUNNING_EXECUTION);
            this.taskCallbackService.sendTaskExecuteRunningCommand(this.taskExecutionContext);
            List<Pair<String, String>> fileDownloads = this.downloadCheck(this.taskExecutionContext.getExecutePath(), this.taskExecutionContext.getResources());
            if (!fileDownloads.isEmpty()) {
                this.downloadResource(this.taskExecutionContext.getExecutePath(), this.logger, fileDownloads);
            }
            this.taskExecutionContext.setEnvFile(CommonUtils.getSystemEnvPath());
            this.taskExecutionContext.setDefinedParams(this.getGlobalParamsMap());
            this.taskExecutionContext.setTaskAppId(String.format("%s_%s", this.taskExecutionContext.getProcessInstanceId(), this.taskExecutionContext.getTaskInstanceId()));
            this.preBuildBusinessParams();
            TaskChannel taskChannel = (TaskChannel)this.taskPluginManager.getTaskChannelMap().get(this.taskExecutionContext.getTaskType());
            if (null == taskChannel) {
                throw new ServiceException(String.format("%s Task Plugin Not Found,Please Check Config File.", this.taskExecutionContext.getTaskType()));
            }
            String taskLogName = LoggerUtils.buildTaskId((Date)this.taskExecutionContext.getFirstSubmitTime(), (Long)this.taskExecutionContext.getProcessDefineCode(), (int)this.taskExecutionContext.getProcessDefineVersion(), (int)this.taskExecutionContext.getProcessInstanceId(), (int)this.taskExecutionContext.getTaskInstanceId());
            this.taskExecutionContext.setTaskLogName(taskLogName);
            Thread.currentThread().setName(taskLogName);
            this.task = taskChannel.createTask(this.taskExecutionContext);
            this.task.init();
            this.task.getParameters().setVarPool(this.taskExecutionContext.getVarPool());
            this.task.handle();
            if (this.task.getNeedAlert()) {
                this.sendAlert(this.task.getTaskAlertInfo(), this.task.getExitStatus().getCode());
            }
            this.taskExecutionContext.setCurrentExecutionStatus(ExecutionStatus.of((int)this.task.getExitStatus().getCode()));
            this.taskExecutionContext.setEndTime(DateUtils.getCurrentDate());
            this.taskExecutionContext.setProcessId(this.task.getProcessId());
            this.taskExecutionContext.setAppIds(this.task.getAppIds());
            this.taskExecutionContext.setVarPool(JSONUtils.toJsonString((Object)this.task.getParameters().getVarPool()));
            this.logger.info("task instance id : {},task final status : {}", (Object)this.taskExecutionContext.getTaskInstanceId(), (Object)this.task.getExitStatus());
        }
        catch (Throwable e) {
            this.logger.error("task scheduler failure", e);
            this.kill();
            this.taskExecutionContext.setCurrentExecutionStatus(ExecutionStatus.FAILURE);
            this.taskExecutionContext.setEndTime(DateUtils.getCurrentDate());
            this.taskExecutionContext.setProcessId(this.task.getProcessId());
            this.taskExecutionContext.setAppIds(this.task.getAppIds());
        }
        finally {
            TaskExecutionContextCacheManager.removeByTaskInstanceId((Integer)this.taskExecutionContext.getTaskInstanceId());
            this.taskCallbackService.sendTaskExecuteResponseCommand(this.taskExecutionContext);
            this.clearTaskExecPath();
        }
    }

    private void sendAlert(TaskAlertInfo taskAlertInfo, int status) {
        int strategy = status == ExecutionStatus.SUCCESS.getCode() ? WarningType.SUCCESS.getCode() : WarningType.FAILURE.getCode();
        this.alertClientService.sendAlert(taskAlertInfo.getAlertGroupId().intValue(), taskAlertInfo.getTitle(), taskAlertInfo.getContent(), strategy);
    }

    private void clearTaskExecPath() {
        this.logger.info("develop mode is: {}", (Object)CommonUtils.isDevelopMode());
        if (!CommonUtils.isDevelopMode()) {
            String execLocalPath = this.taskExecutionContext.getExecutePath();
            if (StringUtils.isEmpty((String)execLocalPath)) {
                this.logger.warn("task: {} exec local path is empty.", (Object)this.taskExecutionContext.getTaskName());
                return;
            }
            if ("/".equals(execLocalPath)) {
                this.logger.warn("task: {} exec local path is '/', direct deletion is not allowed", (Object)this.taskExecutionContext.getTaskName());
                return;
            }
            try {
                FileUtils.deleteDirectory((File)new File(execLocalPath));
                this.logger.info("exec local path: {} cleared.", (Object)execLocalPath);
            }
            catch (IOException e) {
                this.logger.error("delete exec dir failed : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private Map<String, String> getGlobalParamsMap() {
        HashMap<String, String> globalParamsMap = new HashMap<String, String>(16);
        String globalParamsStr = this.taskExecutionContext.getGlobalParams();
        if (globalParamsStr != null) {
            List globalParamsList = JSONUtils.toList((String)globalParamsStr, Property.class);
            globalParamsMap.putAll(globalParamsList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue)));
        }
        return globalParamsMap;
    }

    public void kill() {
        if (this.task != null) {
            try {
                this.task.cancelApplication(true);
                ProcessUtils.killYarnJob((TaskExecutionContext)this.taskExecutionContext);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void downloadResource(String execLocalPath, Logger logger, List<Pair<String, String>> fileDownloads) {
        for (Pair<String, String> fileDownload : fileDownloads) {
            try {
                String fullName = (String)fileDownload.getLeft();
                String tenantCode = (String)fileDownload.getRight();
                String resHdfsPath = this.storageOperate.getResourceFileName(tenantCode, fullName);
                logger.info("get resource file from hdfs :{}", (Object)resHdfsPath);
                this.storageOperate.download(tenantCode, resHdfsPath, execLocalPath + File.separator + fullName, false, true);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new ServiceException(e.getMessage());
            }
        }
    }

    public List<Pair<String, String>> downloadCheck(String execLocalPath, Map<String, String> projectRes) {
        if (MapUtils.isEmpty(projectRes)) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, String>> downloadFile = new ArrayList<Pair<String, String>>();
        projectRes.forEach((key, value) -> {
            boolean notExist;
            File resFile = new File(execLocalPath, (String)key);
            boolean bl = notExist = !resFile.exists();
            if (notExist) {
                downloadFile.add(Pair.of((Object)key, (Object)value));
            } else {
                this.logger.info("file : {} exists ", (Object)resFile.getName());
            }
        });
        if (!downloadFile.isEmpty() && !PropertyUtils.getResUploadStartupState()) {
            throw new StorageOperateNoConfiguredException("Storage service config does not exist!");
        }
        return downloadFile;
    }

    public TaskExecutionContext getTaskExecutionContext() {
        return this.taskExecutionContext;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(DateUtils.getRemainTime((Date)this.taskExecutionContext.getFirstSubmitTime(), (long)((long)this.taskExecutionContext.getDelayTime() * 60L)), TimeUnit.SECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        if (o == null) {
            return 1;
        }
        return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
    }

    public AbstractTask getTask() {
        return this.task;
    }

    private void preBuildBusinessParams() {
        HashMap<String, Property> paramsMap = new HashMap<String, Property>();
        if (this.taskExecutionContext.getScheduleTime() != null) {
            Date date = this.taskExecutionContext.getScheduleTime();
            String dateTime = DateUtils.format((Date)date, (String)"yyyyMMddHHmmss", null);
            Property p = new Property();
            p.setValue(dateTime);
            p.setProp("system.datetime");
            paramsMap.put("system.datetime", p);
        }
        this.taskExecutionContext.setParamsMap(paramsMap);
    }
}

