/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner;

import java.util.Map;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.server.worker.cache.ResponseCache;
import org.apache.dolphinscheduler.server.worker.processor.TaskCallbackService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RetryReportTaskStatusThread
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(RetryReportTaskStatusThread.class);
    private static long RETRY_REPORT_TASK_STATUS_INTERVAL = 300000L;
    @Autowired
    private TaskCallbackService taskCallbackService;

    public void start() {
        Thread thread = new Thread((Runnable)this, "RetryReportTaskStatusThread");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        ResponseCache instance = ResponseCache.get();
        while (Stopper.isRunning()) {
            ThreadUtils.sleep((long)RETRY_REPORT_TASK_STATUS_INTERVAL);
            try {
                Integer taskInstanceId;
                if (!instance.getRunningCache().isEmpty()) {
                    Map<Integer, Command> runningCache = instance.getRunningCache();
                    for (Map.Entry<Integer, Command> entry : runningCache.entrySet()) {
                        taskInstanceId = entry.getKey();
                        Command runningCommand = entry.getValue();
                        this.taskCallbackService.send(taskInstanceId, runningCommand);
                    }
                }
                if (instance.getResponseCache().isEmpty()) continue;
                Map<Integer, Command> responseCache = instance.getResponseCache();
                for (Map.Entry<Integer, Command> entry : responseCache.entrySet()) {
                    taskInstanceId = entry.getKey();
                    Command responseCommand = entry.getValue();
                    this.taskCallbackService.send(taskInstanceId, responseCommand);
                }
            }
            catch (Exception e) {
                this.logger.warn("retry report task status error", (Throwable)e);
            }
        }
    }
}

