/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContextCacheManager;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskKillRequestCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRemoteChannel;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.remote.utils.Pair;
import org.apache.dolphinscheduler.server.utils.ProcessUtils;
import org.apache.dolphinscheduler.server.worker.processor.TaskCallbackService;
import org.apache.dolphinscheduler.server.worker.runner.TaskExecuteThread;
import org.apache.dolphinscheduler.server.worker.runner.WorkerManagerThread;
import org.apache.dolphinscheduler.service.log.LogClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskKillProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskKillProcessor.class);
    @Autowired
    private TaskCallbackService taskCallbackService;
    @Autowired
    private WorkerManagerThread workerManager;

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_KILL_REQUEST == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskKillRequestCommand killCommand = (TaskKillRequestCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskKillRequestCommand.class);
        if (killCommand == null) {
            this.logger.error("task kill request command is null");
            return;
        }
        this.logger.info("task kill command : {}", (Object)killCommand);
        int taskInstanceId = killCommand.getTaskInstanceId();
        TaskExecutionContext taskExecutionContext = TaskExecutionContextCacheManager.getByTaskInstanceId((Integer)taskInstanceId);
        if (taskExecutionContext == null) {
            this.logger.error("taskRequest cache is null, taskInstanceId: {}", (Object)killCommand.getTaskInstanceId());
            return;
        }
        int processId = taskExecutionContext.getProcessId();
        if (processId == 0) {
            this.cancelApplication(taskInstanceId);
            this.workerManager.killTaskBeforeExecuteByInstanceId(taskInstanceId);
            TaskExecutionContextCacheManager.removeByTaskInstanceId((Integer)taskInstanceId);
            this.logger.info("the task has not been executed and has been cancelled, task id:{}", (Object)taskInstanceId);
            return;
        }
        Pair<Boolean, List<String>> result = this.doKill(taskExecutionContext);
        this.taskCallbackService.addRemoteChannel(killCommand.getTaskInstanceId(), new NettyRemoteChannel(channel, command.getOpaque()));
        taskExecutionContext.setCurrentExecutionStatus((Boolean)result.getLeft() != false ? ExecutionStatus.SUCCESS : ExecutionStatus.FAILURE);
        taskExecutionContext.setAppIds(String.join((CharSequence)",", (Iterable)result.getRight()));
        this.taskCallbackService.sendTaskKillResponseCommand(taskExecutionContext);
        TaskExecutionContextCacheManager.removeByTaskInstanceId((Integer)taskExecutionContext.getTaskInstanceId());
        this.logger.info("remove REMOTE_CHANNELS, task instance id:{}", (Object)killCommand.getTaskInstanceId());
    }

    private Pair<Boolean, List<String>> doKill(TaskExecutionContext taskExecutionContext) {
        boolean processFlag = this.killProcess(taskExecutionContext.getTenantCode(), taskExecutionContext.getProcessId());
        Pair<Boolean, List<String>> yarnResult = this.killYarnJob(Host.of((String)taskExecutionContext.getHost()), taskExecutionContext.getLogPath(), taskExecutionContext.getExecutePath(), taskExecutionContext.getTenantCode());
        return Pair.of((Object)(processFlag && (Boolean)yarnResult.getLeft() != false ? 1 : 0), (Object)yarnResult.getRight());
    }

    protected void cancelApplication(int taskInstanceId) {
        TaskExecuteThread taskExecuteThread = this.workerManager.getTaskExecuteThread(taskInstanceId);
        if (taskExecuteThread == null) {
            this.logger.warn("taskExecuteThread not found, taskInstanceId:{}", (Object)taskInstanceId);
            return;
        }
        AbstractTask task = taskExecuteThread.getTask();
        if (task == null) {
            this.logger.warn("task not found, taskInstanceId:{}", (Object)taskInstanceId);
            return;
        }
        try {
            task.cancelApplication(true);
        }
        catch (Exception e) {
            this.logger.error("kill task error", (Throwable)e);
        }
        this.logger.info("kill task by cancelApplication, task id:{}", (Object)taskInstanceId);
    }

    protected boolean killProcess(String tenantCode, Integer processId) {
        boolean processFlag = true;
        if (processId == null || processId.equals(0)) {
            return true;
        }
        try {
            String pidsStr = ProcessUtils.getPidsStr((int)processId);
            if (!StringUtils.isEmpty((String)pidsStr)) {
                String cmd = String.format("kill -9 %s", pidsStr);
                cmd = OSUtils.getSudoCmd((String)tenantCode, (String)cmd);
                this.logger.info("process id:{}, cmd:{}", (Object)processId, (Object)cmd);
                OSUtils.exeCmd((String)cmd);
            }
        }
        catch (Exception e) {
            processFlag = false;
            this.logger.error("kill task error", (Throwable)e);
        }
        return processFlag;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Pair<Boolean, List<String>> killYarnJob(Host host, String logPath, String executePath, String tenantCode) {
        try (LogClientService logClient = new LogClientService();){
            this.logger.info("log host : {} , logPath : {} , port : {}", new Object[]{host.getIp(), logPath, host.getPort()});
            String log = logClient.viewLog(host.getIp(), host.getPort(), logPath);
            List appIds = Collections.emptyList();
            if (!StringUtils.isEmpty((String)log)) {
                appIds = LoggerUtils.getAppIds((String)log, (Logger)this.logger);
                if (StringUtils.isEmpty((String)executePath)) {
                    this.logger.error("task instance execute path is empty");
                    throw new RuntimeException("task instance execute path is empty");
                }
                if (appIds.size() > 0) {
                    ProcessUtils.cancelApplication((List)appIds, (Logger)this.logger, (String)tenantCode, (String)executePath);
                }
            }
            Pair pair = Pair.of((Object)true, appIds);
            return pair;
        }
        catch (Exception e) {
            this.logger.error("kill yarn job error", (Throwable)e);
            return Pair.of((Object)false, Collections.emptyList());
        }
    }
}

