/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskExecuteRunningAckCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.worker.cache.ResponseCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskExecuteRunningAckProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskExecuteRunningAckProcessor.class);

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_EXECUTE_RUNNING_ACK == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskExecuteRunningAckCommand runningAckCommand = (TaskExecuteRunningAckCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskExecuteRunningAckCommand.class);
        if (runningAckCommand == null) {
            this.logger.error("task execute running ack command is null");
            return;
        }
        this.logger.info("task execute running ack command : {}", (Object)runningAckCommand);
        if (runningAckCommand.getStatus() == ExecutionStatus.SUCCESS.getCode()) {
            ResponseCache.get().removeRunningCache(runningAckCommand.getTaskInstanceId());
        }
    }
}

