/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskExecuteResponseAckCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.worker.cache.ResponseCache;
import org.apache.dolphinscheduler.server.worker.processor.TaskCallbackService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskExecuteResponseAckProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskExecuteResponseAckProcessor.class);

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_EXECUTE_RESPONSE_ACK == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskExecuteResponseAckCommand taskExecuteResponseAckCommand = (TaskExecuteResponseAckCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskExecuteResponseAckCommand.class);
        if (taskExecuteResponseAckCommand == null) {
            this.logger.error("task execute response ack command is null");
            return;
        }
        this.logger.info("task execute response ack command : {}", (Object)taskExecuteResponseAckCommand);
        if (taskExecuteResponseAckCommand.getStatus() == ExecutionStatus.SUCCESS.getCode()) {
            ResponseCache.get().removeResponseCache(taskExecuteResponseAckCommand.getTaskInstanceId());
            TaskCallbackService.remove(taskExecuteResponseAckCommand.getTaskInstanceId());
            this.logger.debug("remove REMOTE_CHANNELS, task instance id:{}", (Object)taskExecuteResponseAckCommand.getTaskInstanceId());
        }
    }
}

