/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.HostUpdateCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRemoteChannel;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskCallbackService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HostUpdateProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(HostUpdateProcessor.class);
    @Autowired
    private TaskCallbackService taskCallbackService;

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.PROCESS_HOST_UPDATE_REQUEST == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        HostUpdateCommand updateCommand = (HostUpdateCommand)JSONUtils.parseObject((byte[])command.getBody(), HostUpdateCommand.class);
        if (updateCommand == null) {
            this.logger.error("host update command is null");
            return;
        }
        this.logger.info("received host update command : {}", (Object)updateCommand);
        this.taskCallbackService.changeRemoteChannel(updateCommand.getTaskInstanceId(), new NettyRemoteChannel(channel, command.getOpaque()));
    }
}

