/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.config;

import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties
@ConfigurationProperties(value="worker")
public class WorkerConfig {
    private int listenPort;
    private int execThreads;
    private int heartbeatInterval;
    private int hostWeight;
    private boolean tenantAutoCreate;
    private int maxCpuLoadAvg;
    private double reservedMemory;
    private Set<String> groups;
    private String alertListenHost;
    private int alertListenPort;

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    public int getExecThreads() {
        return this.execThreads;
    }

    public void setExecThreads(int execThreads) {
        this.execThreads = execThreads;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(int heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public int getHostWeight() {
        return this.hostWeight;
    }

    public void setHostWeight(int hostWeight) {
        this.hostWeight = hostWeight;
    }

    public boolean isTenantAutoCreate() {
        return this.tenantAutoCreate;
    }

    public void setTenantAutoCreate(boolean tenantAutoCreate) {
        this.tenantAutoCreate = tenantAutoCreate;
    }

    public int getMaxCpuLoadAvg() {
        return this.maxCpuLoadAvg > 0 ? this.maxCpuLoadAvg : Runtime.getRuntime().availableProcessors() * 2;
    }

    public void setMaxCpuLoadAvg(int maxCpuLoadAvg) {
        this.maxCpuLoadAvg = maxCpuLoadAvg;
    }

    public double getReservedMemory() {
        return this.reservedMemory;
    }

    public void setReservedMemory(double reservedMemory) {
        this.reservedMemory = reservedMemory;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public String getAlertListenHost() {
        return this.alertListenHost;
    }

    public void setAlertListenHost(String alertListenHost) {
        this.alertListenHost = alertListenHost;
    }

    public int getAlertListenPort() {
        return this.alertListenPort;
    }

    public void setAlertListenPort(int alertListenPort) {
        this.alertListenPort = alertListenPort;
    }
}

