/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.enums.Event;
import org.apache.dolphinscheduler.remote.command.Command;

public class ResponseCache {
    private static final ResponseCache instance = new ResponseCache();
    private Map<Integer, Command> runningCache = new ConcurrentHashMap<Integer, Command>();
    private Map<Integer, Command> responseCache = new ConcurrentHashMap<Integer, Command>();

    private ResponseCache() {
    }

    public static ResponseCache get() {
        return instance;
    }

    public void cache(Integer taskInstanceId, Command command, Event event) {
        switch (event) {
            case RUNNING: {
                this.runningCache.put(taskInstanceId, command);
                break;
            }
            case RESULT: {
                this.responseCache.put(taskInstanceId, command);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid event type : " + event);
            }
        }
    }

    public void removeRunningCache(Integer taskInstanceId) {
        this.runningCache.remove(taskInstanceId);
    }

    public void removeResponseCache(Integer taskInstanceId) {
        this.responseCache.remove(taskInstanceId);
    }

    public Map<Integer, Command> getRunningCache() {
        return this.runningCache;
    }

    public Map<Integer, Command> getResponseCache() {
        return this.responseCache;
    }
}

