/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker;

import java.util.Collection;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.enums.NodeType;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.plugin.task.api.ProcessUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContextCacheManager;
import org.apache.dolphinscheduler.remote.NettyRemotingServer;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.config.NettyServerConfig;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.log.LoggerRequestProcessor;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.processor.HostUpdateProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskExecuteProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskExecuteResponseAckProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskExecuteRunningAckProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskKillProcessor;
import org.apache.dolphinscheduler.server.worker.registry.WorkerRegistryClient;
import org.apache.dolphinscheduler.server.worker.runner.RetryReportTaskStatusThread;
import org.apache.dolphinscheduler.server.worker.runner.WorkerManagerThread;
import org.apache.dolphinscheduler.service.alert.AlertClientService;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.task.TaskPluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@EnableTransactionManagement
@ComponentScan(value={"org.apache.dolphinscheduler"})
public class WorkerServer
implements IStoppable {
    private static final Logger logger = LoggerFactory.getLogger(WorkerServer.class);
    private NettyRemotingServer nettyRemotingServer;
    @Autowired
    private WorkerConfig workerConfig;
    @Autowired
    private SpringApplicationContext springApplicationContext;
    @Autowired
    private AlertClientService alertClientService;
    @Autowired
    private RetryReportTaskStatusThread retryReportTaskStatusThread;
    @Autowired
    private WorkerManagerThread workerManagerThread;
    @Autowired
    private WorkerRegistryClient workerRegistryClient;
    @Autowired
    private TaskPluginManager taskPluginManager;
    @Autowired
    private TaskExecuteProcessor taskExecuteProcessor;
    @Autowired
    private TaskKillProcessor taskKillProcessor;
    @Autowired
    private TaskExecuteRunningAckProcessor taskExecuteRunningAckProcessor;
    @Autowired
    private TaskExecuteResponseAckProcessor taskExecuteResponseAckProcessor;
    @Autowired
    private HostUpdateProcessor hostUpdateProcessor;
    @Autowired
    private LoggerRequestProcessor loggerRequestProcessor;

    public static void main(String[] args) {
        Thread.currentThread().setName("Worker-Server");
        SpringApplication.run(WorkerServer.class, (String[])new String[0]);
    }

    @PostConstruct
    public void run() {
        NettyServerConfig serverConfig = new NettyServerConfig();
        serverConfig.setListenPort(this.workerConfig.getListenPort());
        this.nettyRemotingServer = new NettyRemotingServer(serverConfig);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_EXECUTE_REQUEST, (NettyRequestProcessor)this.taskExecuteProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_KILL_REQUEST, (NettyRequestProcessor)this.taskKillProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_EXECUTE_RUNNING_ACK, (NettyRequestProcessor)this.taskExecuteRunningAckProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_EXECUTE_RESPONSE_ACK, (NettyRequestProcessor)this.taskExecuteResponseAckProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.PROCESS_HOST_UPDATE_REQUEST, (NettyRequestProcessor)this.hostUpdateProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.GET_LOG_BYTES_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.ROLL_VIEW_LOG_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.VIEW_WHOLE_LOG_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.REMOVE_TAK_LOG_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.start();
        this.taskPluginManager.installPlugin();
        try {
            this.workerRegistryClient.registry();
            this.workerRegistryClient.setRegistryStoppable(this);
            Set<String> workerZkPaths = this.workerRegistryClient.getWorkerZkPaths();
            this.workerRegistryClient.handleDeadServer(workerZkPaths, NodeType.WORKER, "delete");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        this.workerManagerThread.start();
        this.retryReportTaskStatusThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (Stopper.isRunning()) {
                this.close("shutdownHook");
            }
        }));
    }

    public void close(String cause) {
        try {
            if (Stopper.isStopped()) {
                return;
            }
            logger.info("worker server is stopping ..., cause : {}", (Object)cause);
            Stopper.stop();
            try {
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                logger.warn("thread sleep exception", (Throwable)e);
            }
            this.nettyRemotingServer.close();
            this.workerRegistryClient.unRegistry();
            this.alertClientService.close();
            this.killAllRunningTasks();
            this.springApplicationContext.close();
        }
        catch (Exception e) {
            logger.error("worker server stop exception ", (Throwable)e);
        }
    }

    public void stop(String cause) {
        this.close(cause);
    }

    public void killAllRunningTasks() {
        Collection taskRequests = TaskExecutionContextCacheManager.getAllTaskRequestList();
        logger.info("ready to kill all cache job, job size:{}", (Object)taskRequests.size());
        if (CollectionUtils.isEmpty((Collection)taskRequests)) {
            return;
        }
        for (TaskExecutionContext taskRequest : taskRequests) {
            ProcessUtils.kill((TaskExecutionContext)taskRequest);
        }
    }
}

