/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.plugin.DataSourceClientProvider;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.CommonUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTaskExecutor;
import org.apache.dolphinscheduler.plugin.task.api.SQLTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.enums.SqlType;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskAlertInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.SqlParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.UdfFuncParameters;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParamUtils;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.sql.SqlBinds;
import org.apache.dolphinscheduler.plugin.task.sql.SqlSplitter;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;

public class SqlTask
extends AbstractTaskExecutor {
    private TaskExecutionContext taskExecutionContext;
    private SqlParameters sqlParameters;
    private BaseConnectionParam baseConnectionParam;
    private static final String CREATE_FUNCTION_FORMAT = "create temporary function {0} as ''{1}''";
    private static final int QUERY_LIMIT = 10000;
    private SQLTaskExecutionContext sqlTaskExecutionContext;

    public SqlTask(TaskExecutionContext taskRequest) {
        super(taskRequest);
        this.taskExecutionContext = taskRequest;
        this.sqlParameters = (SqlParameters)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), SqlParameters.class);
        assert (this.sqlParameters != null);
        if (!this.sqlParameters.checkParameters()) {
            throw new RuntimeException("sql task params is not valid");
        }
        this.sqlTaskExecutionContext = this.sqlParameters.generateExtendedContext(this.taskExecutionContext.getResourceParametersHelper());
    }

    public AbstractParameters getParameters() {
        return this.sqlParameters;
    }

    public void handle() throws Exception {
        this.logger.info("Full sql parameters: {}", (Object)this.sqlParameters);
        this.logger.info("sql type : {}, datasource : {}, sql : {} , localParams : {},udfs : {},showType : {},connParams : {},varPool : {} ,query max result limit  {}", new Object[]{this.sqlParameters.getType(), this.sqlParameters.getDatasource(), this.sqlParameters.getSql(), this.sqlParameters.getLocalParams(), this.sqlParameters.getUdfs(), this.sqlParameters.getShowType(), this.sqlParameters.getConnParams(), this.sqlParameters.getVarPool(), this.sqlParameters.getLimit()});
        try {
            this.baseConnectionParam = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)DbType.valueOf((String)this.sqlParameters.getType()), (String)this.sqlTaskExecutionContext.getConnectionParams());
            List<SqlBinds> mainStatementSqlBinds = SqlSplitter.split(this.sqlParameters.getSql(), this.sqlParameters.getSegmentSeparator()).stream().map(this::getSqlAndSqlParamsMap).collect(Collectors.toList());
            List<SqlBinds> preStatementSqlBinds = ((List)Optional.ofNullable(this.sqlParameters.getPreStatements()).orElse(new ArrayList())).stream().map(this::getSqlAndSqlParamsMap).collect(Collectors.toList());
            List<SqlBinds> postStatementSqlBinds = ((List)Optional.ofNullable(this.sqlParameters.getPostStatements()).orElse(new ArrayList())).stream().map(this::getSqlAndSqlParamsMap).collect(Collectors.toList());
            List<String> createFuncs = this.createFuncs(this.sqlTaskExecutionContext.getUdfFuncParametersList(), this.logger);
            this.executeFuncAndSql(mainStatementSqlBinds, preStatementSqlBinds, postStatementSqlBinds, createFuncs);
            this.setExitStatusCode(0);
        }
        catch (Exception e) {
            this.setExitStatusCode(-1);
            this.logger.error("sql task error", (Throwable)e);
            throw e;
        }
    }

    public void executeFuncAndSql(List<SqlBinds> mainStatementsBinds, List<SqlBinds> preStatementsBinds, List<SqlBinds> postStatementsBinds, List<String> createFuncs) throws Exception {
        Connection connection = null;
        try {
            connection = DataSourceClientProvider.getInstance().getConnection(DbType.valueOf((String)this.sqlParameters.getType()), (ConnectionParam)this.baseConnectionParam);
            if (CollectionUtils.isNotEmpty(createFuncs)) {
                this.createTempFunction(connection, createFuncs);
            }
            this.executeUpdate(connection, preStatementsBinds, "pre");
            String result = null;
            if (this.sqlParameters.getSqlType() == SqlType.QUERY.ordinal()) {
                result = this.executeQuery(connection, mainStatementsBinds.get(0), "main");
            } else if (this.sqlParameters.getSqlType() == SqlType.NON_QUERY.ordinal()) {
                String updateResult = this.executeUpdate(connection, mainStatementsBinds, "main");
                result = this.setNonQuerySqlReturn(updateResult, this.sqlParameters.getLocalParams());
            }
            this.sqlParameters.dealOutParam(result);
            this.executeUpdate(connection, postStatementsBinds, "post");
            this.close(connection);
        }
        catch (Exception e) {
            try {
                this.logger.error("execute sql error: {}", (Object)e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(connection);
                throw throwable;
            }
        }
    }

    private String setNonQuerySqlReturn(String updateResult, List<Property> properties) {
        String result = null;
        for (Property info : properties) {
            if (Direct.OUT != info.getDirect()) continue;
            ArrayList updateRL = new ArrayList();
            HashMap<String, String> updateRM = new HashMap<String, String>();
            updateRM.put(info.getProp(), updateResult);
            updateRL.add(updateRM);
            result = JSONUtils.toJsonString(updateRL);
            break;
        }
        return result;
    }

    private String resultProcess(ResultSet resultSet) throws Exception {
        String result;
        ArrayNode resultJSONArray = JSONUtils.createArrayNode();
        if (resultSet != null) {
            int i;
            int limit;
            ResultSetMetaData md = resultSet.getMetaData();
            int num = md.getColumnCount();
            int rowCount = 0;
            int n = limit = this.sqlParameters.getLimit() == 0 ? 10000 : this.sqlParameters.getLimit();
            while (resultSet.next()) {
                if (rowCount == limit) {
                    this.logger.info("sql result limit : {} exceeding results are filtered", (Object)limit);
                    break;
                }
                ObjectNode mapOfColValues = JSONUtils.createObjectNode();
                for (i = 1; i <= num; ++i) {
                    mapOfColValues.set(md.getColumnLabel(i), JSONUtils.toJsonNode((Object)resultSet.getObject(i)));
                }
                resultJSONArray.add((JsonNode)mapOfColValues);
                ++rowCount;
            }
            int displayRows = this.sqlParameters.getDisplayRows() > 0 ? this.sqlParameters.getDisplayRows() : 10;
            displayRows = Math.min(displayRows, rowCount);
            this.logger.info("display sql result {} rows as follows:", (Object)displayRows);
            for (i = 0; i < displayRows; ++i) {
                String row = JSONUtils.toJsonString((Object)resultJSONArray.get(i));
                this.logger.info("row {} : {}", (Object)(i + 1), (Object)row);
            }
        }
        String string = result = resultJSONArray.isEmpty() ? JSONUtils.toJsonString((Object)this.generateEmptyRow(resultSet)) : JSONUtils.toJsonString((Object)resultJSONArray);
        if (this.sqlParameters.getSendEmail() == null || this.sqlParameters.getSendEmail().booleanValue()) {
            this.sendAttachment(this.sqlParameters.getGroupId(), StringUtils.isNotEmpty((CharSequence)this.sqlParameters.getTitle()) ? this.sqlParameters.getTitle() : this.taskExecutionContext.getTaskName() + " query result sets", result);
        }
        this.logger.debug("execute sql result : {}", (Object)result);
        return result;
    }

    private ArrayNode generateEmptyRow(ResultSet resultSet) throws SQLException {
        ArrayNode resultJSONArray = JSONUtils.createArrayNode();
        ObjectNode emptyOfColValues = JSONUtils.createObjectNode();
        if (resultSet != null) {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnsNum = metaData.getColumnCount();
            this.logger.info("sql query results is empty");
            for (int i = 1; i <= columnsNum; ++i) {
                emptyOfColValues.set(metaData.getColumnLabel(i), JSONUtils.toJsonNode((Object)""));
            }
        } else {
            emptyOfColValues.set("error", JSONUtils.toJsonNode((Object)"resultSet is null"));
        }
        resultJSONArray.add((JsonNode)emptyOfColValues);
        return resultJSONArray;
    }

    private void sendAttachment(int groupId, String title, String content) {
        this.setNeedAlert(Boolean.TRUE);
        TaskAlertInfo taskAlertInfo = new TaskAlertInfo();
        taskAlertInfo.setAlertGroupId(Integer.valueOf(groupId));
        taskAlertInfo.setContent(content);
        taskAlertInfo.setTitle(title);
        this.setTaskAlertInfo(taskAlertInfo);
    }

    private String executeQuery(Connection connection, SqlBinds sqlBinds, String handlerType) throws Exception {
        try (PreparedStatement statement = this.prepareStatementAndBind(connection, sqlBinds);){
            this.logger.info("{} statement execute query, for sql: {}", (Object)handlerType, (Object)sqlBinds.getSql());
            ResultSet resultSet = statement.executeQuery();
            String string = this.resultProcess(resultSet);
            return string;
        }
    }

    private String executeUpdate(Connection connection, List<SqlBinds> statementsBinds, String handlerType) throws Exception {
        int result = 0;
        for (SqlBinds sqlBind : statementsBinds) {
            PreparedStatement statement = this.prepareStatementAndBind(connection, sqlBind);
            Throwable throwable = null;
            try {
                result = statement.executeUpdate();
                this.logger.info("{} statement execute update result: {}, for sql: {}", new Object[]{handlerType, result, sqlBind.getSql()});
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                statement.close();
            }
        }
        return String.valueOf(result);
    }

    private void createTempFunction(Connection connection, List<String> createFuncs) throws Exception {
        try (Statement funcStmt = connection.createStatement();){
            for (String createFunc : createFuncs) {
                this.logger.info("hive create function sql: {}", (Object)createFunc);
                funcStmt.execute(createFunc);
            }
        }
    }

    private void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                this.logger.error("close connection error : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private PreparedStatement prepareStatementAndBind(Connection connection, SqlBinds sqlBinds) {
        boolean timeoutFlag = this.taskExecutionContext.getTaskTimeoutStrategy() == TaskTimeoutStrategy.FAILED || this.taskExecutionContext.getTaskTimeoutStrategy() == TaskTimeoutStrategy.WARNFAILED;
        try {
            Map<Integer, Property> params;
            PreparedStatement stmt = connection.prepareStatement(sqlBinds.getSql());
            if (timeoutFlag) {
                stmt.setQueryTimeout(this.taskExecutionContext.getTaskTimeout());
            }
            if ((params = sqlBinds.getParamsMap()) != null) {
                for (Map.Entry<Integer, Property> entry : params.entrySet()) {
                    Property prop = entry.getValue();
                    ParameterUtils.setInParameter((int)entry.getKey(), (PreparedStatement)stmt, (DataType)prop.getType(), (String)prop.getValue());
                }
            }
            this.logger.info("prepare statement replace sql : {} ", (Object)stmt);
            return stmt;
        }
        catch (Exception exception) {
            throw new TaskException("SQL task prepareStatementAndBind error", (Throwable)exception);
        }
    }

    private void printReplacedSql(String content, String formatSql, String rgex, Map<Integer, Property> sqlParamsMap) {
        this.logger.info("after replace sql , preparing : {}", (Object)formatSql);
        StringBuilder logPrint = new StringBuilder("replaced sql , parameters:");
        if (sqlParamsMap == null) {
            this.logger.info("printReplacedSql: sqlParamsMap is null.");
        } else {
            for (int i = 1; i <= sqlParamsMap.size(); ++i) {
                logPrint.append(sqlParamsMap.get(i).getValue()).append("(").append(sqlParamsMap.get(i).getType()).append(")");
            }
        }
        this.logger.info("Sql Params are {}", (Object)logPrint);
    }

    private SqlBinds getSqlAndSqlParamsMap(String sql) {
        HashMap<Integer, Property> sqlParamsMap = new HashMap<Integer, Property>();
        StringBuilder sqlBuilder = new StringBuilder();
        Map paramsMap = ParamUtils.convert((TaskExecutionContext)this.taskExecutionContext, (AbstractParameters)this.getParameters());
        if (paramsMap == null) {
            sqlBuilder.append(sql);
            return new SqlBinds(sqlBuilder.toString(), sqlParamsMap);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.sqlParameters.getTitle())) {
            String title = ParameterUtils.convertParameterPlaceholders((String)this.sqlParameters.getTitle(), (Map)ParamUtils.convert((Map)paramsMap));
            this.logger.info("SQL title : {}", (Object)title);
            this.sqlParameters.setTitle(title);
        }
        sql = ParameterUtils.replaceScheduleTime((String)sql, (Date)this.taskExecutionContext.getScheduleTime());
        this.setSqlParamsMap(sql, this.rgex, sqlParamsMap, paramsMap, this.taskExecutionContext.getTaskInstanceId());
        String rgexo = "['\"]*\\!\\{(.*?)\\}['\"]*";
        sql = this.replaceOriginalValue(sql, rgexo, paramsMap);
        String formatSql = sql.replaceAll(this.rgex, "?");
        formatSql = ParameterUtils.expandListParameter(sqlParamsMap, (String)formatSql);
        sqlBuilder.append(formatSql);
        this.printReplacedSql(sql, formatSql, this.rgex, sqlParamsMap);
        return new SqlBinds(sqlBuilder.toString(), sqlParamsMap);
    }

    private String replaceOriginalValue(String content, String rgex, Map<String, Property> sqlParamsMap) {
        Matcher m;
        Pattern pattern = Pattern.compile(rgex);
        while ((m = pattern.matcher(content)).find()) {
            String paramName = m.group(1);
            String paramValue = sqlParamsMap.get(paramName).getValue();
            content = m.replaceFirst(paramValue);
        }
        return content;
    }

    private List<String> createFuncs(List<UdfFuncParameters> udfFuncParameters, Logger logger) {
        if (CollectionUtils.isEmpty(udfFuncParameters)) {
            logger.info("can't find udf function resource");
            return null;
        }
        List<String> funcList = this.buildJarSql(udfFuncParameters);
        List<String> tempFuncList = this.buildTempFuncSql(udfFuncParameters);
        funcList.addAll(tempFuncList);
        return funcList;
    }

    private List<String> buildTempFuncSql(List<UdfFuncParameters> udfFuncParameters) {
        return udfFuncParameters.stream().map(value -> MessageFormat.format(CREATE_FUNCTION_FORMAT, value.getFuncName(), value.getClassName())).collect(Collectors.toList());
    }

    private List<String> buildJarSql(List<UdfFuncParameters> udfFuncParameters) {
        return udfFuncParameters.stream().map(value -> {
            String defaultFS = value.getDefaultFS();
            String prefixPath = defaultFS.startsWith("file://") ? "file://" : defaultFS;
            String uploadPath = CommonUtils.getHdfsUdfDir((String)value.getTenantCode());
            String resourceFullName = value.getResourceName();
            resourceFullName = resourceFullName.startsWith("/") ? resourceFullName : String.format("/%s", resourceFullName);
            return String.format("add jar %s%s%s", prefixPath, uploadPath, resourceFullName);
        }).collect(Collectors.toList());
    }
}

