/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SqlSplitter {
    private static final String LINE_SEPARATOR = "\n";

    private SqlSplitter() {
    }

    public static List<String> split(String sql, String segmentSeparator) {
        if (StringUtils.isBlank((String)segmentSeparator)) {
            return Collections.singletonList(sql);
        }
        String[] lines = sql.split(LINE_SEPARATOR);
        ArrayList<String> segments = new ArrayList<String>();
        StringBuilder stmt = new StringBuilder();
        for (String line : lines) {
            if (line.trim().isEmpty() || line.startsWith("--")) continue;
            stmt.append(LINE_SEPARATOR).append(line);
            if (!line.trim().endsWith(segmentSeparator)) continue;
            segments.add(stmt.toString());
            stmt.setLength(0);
        }
        if (stmt.length() > 0) {
            segments.add(stmt.toString());
        }
        return segments;
    }
}

