/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.pytorch;

import lombok.Generated;

public class PythonEnvManager {
    public static final String ENV_TOOL_VENV = "virtualenv";
    public static final String ENV_TOOL_CONDA = "conda";
    private static final String PATTERN_ENVIRONMENT_PYTHON = "python[\\d\\.]*$";
    private static final String PATTERN_ENVIRONMENT_REQUIREMENT = "\\.txt$";
    private static final String CREATE_ENV_NAME = "./venv";
    private static final String CONDA_SOURCE = "source activate %s";
    private static final String CONDA_BUILD = "conda create -y python=%s -p %s";
    private static final String VIRTUALENV_SOURCE = "source %s/bin/activate";
    private static final String VIRTUALENV_BUILD = "virtualenv -p ${PYTHON_HOME} %s";
    private static final String INSTALL_COMMAND = "%s -m pip install -r %s";
    private String pythonEnvTool = "virtualenv";
    private String condaPythonVersion = "3.9";

    public String getBuildEnvCommand(String requirementPath) {
        String buildCommand = "";
        String sourceCommand = this.getSourceEnvCommand(CREATE_ENV_NAME);
        if (this.pythonEnvTool.equals(ENV_TOOL_VENV)) {
            buildCommand = String.format(VIRTUALENV_BUILD, CREATE_ENV_NAME);
        } else if (this.pythonEnvTool.equals(ENV_TOOL_CONDA)) {
            buildCommand = String.format(CONDA_BUILD, this.condaPythonVersion, CREATE_ENV_NAME);
        }
        String installCommand = String.format(INSTALL_COMMAND, this.getPythonCommand(), requirementPath);
        return buildCommand + " && " + sourceCommand + " && " + installCommand;
    }

    private String getSourceEnvCommand(String envName) {
        String command = "";
        if (this.pythonEnvTool.equals(ENV_TOOL_VENV)) {
            command = String.format(VIRTUALENV_SOURCE, envName);
        } else if (this.pythonEnvTool.equals(ENV_TOOL_CONDA)) {
            command = String.format(CONDA_SOURCE, envName);
        }
        return command;
    }

    public String getPythonCommand() {
        return String.format("%s/bin/python", CREATE_ENV_NAME);
    }

    @Generated
    public PythonEnvManager() {
    }

    @Generated
    public String getPythonEnvTool() {
        return this.pythonEnvTool;
    }

    @Generated
    public String getCondaPythonVersion() {
        return this.condaPythonVersion;
    }

    @Generated
    public void setPythonEnvTool(String pythonEnvTool) {
        this.pythonEnvTool = pythonEnvTool;
    }

    @Generated
    public void setCondaPythonVersion(String condaPythonVersion) {
        this.condaPythonVersion = condaPythonVersion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PythonEnvManager)) {
            return false;
        }
        PythonEnvManager other = (PythonEnvManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pythonEnvTool = this.getPythonEnvTool();
        String other$pythonEnvTool = other.getPythonEnvTool();
        if (this$pythonEnvTool == null ? other$pythonEnvTool != null : !this$pythonEnvTool.equals(other$pythonEnvTool)) {
            return false;
        }
        String this$condaPythonVersion = this.getCondaPythonVersion();
        String other$condaPythonVersion = other.getCondaPythonVersion();
        return !(this$condaPythonVersion == null ? other$condaPythonVersion != null : !this$condaPythonVersion.equals(other$condaPythonVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PythonEnvManager;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pythonEnvTool = this.getPythonEnvTool();
        result = result * 59 + ($pythonEnvTool == null ? 43 : $pythonEnvTool.hashCode());
        String $condaPythonVersion = this.getCondaPythonVersion();
        result = result * 59 + ($condaPythonVersion == null ? 43 : $condaPythonVersion.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PythonEnvManager(pythonEnvTool=" + this.getPythonEnvTool() + ", condaPythonVersion=" + this.getCondaPythonVersion() + ")";
    }
}

