/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.python;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTaskExecutor;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParamUtils;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.MapUtils;
import org.apache.dolphinscheduler.plugin.task.python.PythonParameters;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;

public class PythonTask
extends AbstractTaskExecutor {
    private PythonParameters pythonParameters;
    private ShellCommandExecutor shellCommandExecutor;
    private TaskExecutionContext taskRequest;
    private static final String PYTHON_HOME = "PYTHON_HOME";
    private static final String DEFAULT_PYTHON_VERSION = "python";

    public PythonTask(TaskExecutionContext taskRequest) {
        super(taskRequest);
        this.taskRequest = taskRequest;
        this.shellCommandExecutor = new ShellCommandExecutor(arg_0 -> ((PythonTask)this).logHandle(arg_0), taskRequest, this.logger);
    }

    public void init() {
        this.logger.info("python task params {}", (Object)this.taskRequest.getTaskParams());
        this.pythonParameters = (PythonParameters)((Object)JSONUtils.parseObject((String)this.taskRequest.getTaskParams(), PythonParameters.class));
        if (!this.pythonParameters.checkParameters()) {
            throw new TaskException("python task params is not valid");
        }
    }

    public String getPreScript() {
        String rawPythonScript = this.pythonParameters.getRawScript().replaceAll("\\r\\n", "\n");
        try {
            rawPythonScript = PythonTask.convertPythonScriptPlaceholders(rawPythonScript);
        }
        catch (StringIndexOutOfBoundsException e) {
            this.logger.error("setShareVar field format error, raw python script : {}", (Object)rawPythonScript);
        }
        return rawPythonScript;
    }

    public void handle() throws Exception {
        try {
            String pythonScriptContent = this.buildPythonScriptContent();
            String pythonScriptFile = this.buildPythonCommandFilePath();
            this.createPythonCommandFileIfNotExists(pythonScriptContent, pythonScriptFile);
            String command = this.buildPythonExecuteCommand(pythonScriptFile);
            TaskResponse taskResponse = this.shellCommandExecutor.run(command);
            this.setExitStatusCode(taskResponse.getExitStatusCode());
            this.setAppIds(taskResponse.getAppIds());
            this.setProcessId(taskResponse.getProcessId());
            this.setVarPool(this.shellCommandExecutor.getVarPool());
        }
        catch (Exception e) {
            this.logger.error("python task failure", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("run python task error", (Throwable)e);
        }
    }

    public void cancelApplication(boolean cancelApplication) throws Exception {
        this.shellCommandExecutor.cancelApplication();
    }

    public AbstractParameters getParameters() {
        return this.pythonParameters;
    }

    private static String convertPythonScriptPlaceholders(String rawScript) throws StringIndexOutOfBoundsException {
        int len = "${setShareVar(${".length();
        int scriptStart = 0;
        while ((scriptStart = rawScript.indexOf("${setShareVar(${", scriptStart)) != -1) {
            int start = -1;
            int end = rawScript.indexOf(125, scriptStart + len);
            String prop = rawScript.substring(scriptStart + len, end);
            start = rawScript.indexOf(44, end);
            end = rawScript.indexOf(41, start);
            String value = rawScript.substring(start + 1, end);
            start = rawScript.indexOf(125, start) + 1;
            end = rawScript.length();
            String replaceScript = String.format("print(\"${{setValue({},{})}}\".format(\"%s\",%s))", prop, value);
            rawScript = rawScript.substring(0, scriptStart) + replaceScript + rawScript.substring(start, end);
            scriptStart += replaceScript.length();
        }
        return rawScript;
    }

    protected void createPythonCommandFileIfNotExists(String pythonScript, String pythonScriptFile) throws IOException {
        this.logger.info("tenantCode :{}, task dir:{}", (Object)this.taskRequest.getTenantCode(), (Object)this.taskRequest.getExecutePath());
        if (!Files.exists(Paths.get(pythonScriptFile, new String[0]), new LinkOption[0])) {
            this.logger.info("generate python script file:{}", (Object)pythonScriptFile);
            StringBuilder sb = new StringBuilder();
            sb.append("#-*- encoding=utf8 -*-\n");
            sb.append("\n\n");
            sb.append(pythonScript);
            this.logger.info(sb.toString());
            FileUtils.writeStringToFile((File)new File(pythonScriptFile), (String)sb.toString(), (Charset)StandardCharsets.UTF_8);
        }
    }

    protected String buildPythonCommandFilePath() {
        return String.format("%s/py_%s.py", this.taskRequest.getExecutePath(), this.taskRequest.getTaskAppId());
    }

    private String buildPythonScriptContent() throws Exception {
        String rawPythonScript = this.pythonParameters.getRawScript().replaceAll("\\r\\n", "\n");
        HashMap paramsMap = ParamUtils.convert((TaskExecutionContext)this.taskRequest, (AbstractParameters)this.pythonParameters);
        if (MapUtils.isEmpty((Map)paramsMap)) {
            paramsMap = new HashMap();
        }
        if (MapUtils.isNotEmpty((Map)this.taskRequest.getParamsMap())) {
            paramsMap.putAll(this.taskRequest.getParamsMap());
        }
        rawPythonScript = ParameterUtils.convertParameterPlaceholders((String)rawPythonScript, (Map)ParamUtils.convert(paramsMap));
        this.logger.info("raw python script : {}", (Object)this.pythonParameters.getRawScript());
        return rawPythonScript;
    }

    private String buildPythonExecuteCommand(String pythonFile) {
        Preconditions.checkNotNull((Object)pythonFile, (Object)"Python file cannot be null");
        String pythonHome = System.getenv(PYTHON_HOME);
        if (StringUtils.isEmpty((String)pythonHome)) {
            return "python " + pythonFile;
        }
        return pythonHome + " " + pythonFile;
    }
}

