/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.pigeon;

import java.util.ResourceBundle;
import org.apache.dolphinscheduler.spi.utils.StringUtils;

public class PigeonConfig {
    private static PigeonConfig cfg;
    private final String jobTriggerUrl;
    private final String jobTriggerPostBody;
    private final String jobStatusUrl;
    private final String jobStatusPostBody;
    private final String jobLogsFetchUrl;
    private final String jobCancelPostBody;

    public static synchronized PigeonConfig getInstance() {
        if (cfg == null) {
            cfg = new PigeonConfig();
        }
        return cfg;
    }

    private PigeonConfig() {
        ResourceBundle bundle = ResourceBundle.getBundle(PigeonConfig.class.getPackage().getName().replace(".", "/") + "/config");
        this.jobTriggerUrl = bundle.getString("job.trigger.url");
        this.jobStatusUrl = bundle.getString("job.status.url");
        this.jobTriggerPostBody = bundle.getString("job.trigger.post.body");
        this.jobStatusPostBody = bundle.getString("job.status.post.body");
        this.jobLogsFetchUrl = bundle.getString("job.logs.fetch.url");
        this.jobCancelPostBody = bundle.getString("job.cancel.post.body");
    }

    public String getJobCancelPostBody(int taskId) {
        return String.format(this.jobCancelPostBody, taskId);
    }

    public String getJobTriggerUrl(String tisHost) {
        PigeonConfig.checkHost(tisHost);
        return String.format(this.jobTriggerUrl, tisHost);
    }

    public String getJobTriggerPostBody() {
        return this.jobTriggerPostBody;
    }

    public String getJobStatusPostBody(int taskId) {
        return String.format(this.jobStatusPostBody, taskId);
    }

    public String getJobLogsFetchUrl(String host, String jobName, int taskId) {
        PigeonConfig.checkHost(host);
        return String.format(this.jobLogsFetchUrl, host, jobName, taskId);
    }

    public String getJobStatusUrl(String tisHost) {
        PigeonConfig.checkHost(tisHost);
        return String.format(this.jobStatusUrl, tisHost);
    }

    private static void checkHost(String tisHost) {
        if (StringUtils.isBlank((CharSequence)tisHost)) {
            throw new IllegalArgumentException("param tisHost can not be null");
        }
    }
}

