/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.openmldb;

import com.google.common.base.Preconditions;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParamUtils;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.openmldb.OpenmldbParameters;
import org.apache.dolphinscheduler.plugin.task.python.PythonTask;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;

public class OpenmldbTask
extends PythonTask {
    private OpenmldbParameters openmldbParameters;
    private static final String OPENMLDB_PYTHON = "python3";
    private static final Pattern PYTHON_PATH_PATTERN = Pattern.compile("/bin/python[\\d.]*$");

    public OpenmldbTask(TaskExecutionContext taskRequest) {
        super(taskRequest);
    }

    public void init() {
        this.logger.info("openmldb task params {}", (Object)this.taskRequest.getTaskParams());
        this.openmldbParameters = (OpenmldbParameters)((Object)JSONUtils.parseObject((String)this.taskRequest.getTaskParams(), OpenmldbParameters.class));
        if (this.openmldbParameters == null || !this.openmldbParameters.checkParameters()) {
            throw new TaskException("openmldb task params is not valid");
        }
    }

    @Deprecated
    public String getPreScript() {
        return "";
    }

    public AbstractParameters getParameters() {
        return this.openmldbParameters;
    }

    protected String buildPythonCommandFilePath() {
        return String.format("%s/openmldb_%s.py", this.taskRequest.getExecutePath(), this.taskRequest.getTaskAppId());
    }

    protected String buildPythonScriptContent() {
        this.logger.info("raw sql script : {}", (Object)this.openmldbParameters.getSql());
        String rawSQLScript = this.openmldbParameters.getSql().replaceAll("[\\r]?\\n", "\n");
        Map paramsMap = this.mergeParamsWithContext(this.openmldbParameters);
        rawSQLScript = ParameterUtils.convertParameterPlaceholders((String)rawSQLScript, (Map)ParamUtils.convert((Map)paramsMap));
        String pythonScript = this.buildPythonScriptsFromSql(rawSQLScript);
        this.logger.info("rendered python script : {}", (Object)pythonScript);
        return pythonScript;
    }

    private String buildPythonScriptsFromSql(String rawSqlScript) {
        StringBuilder builder = new StringBuilder("import openmldb\nimport sqlalchemy as db\n");
        builder.append(String.format("engine = db.create_engine('openmldb:///?zk=%s&zkPath=%s')\n", this.openmldbParameters.getZk(), this.openmldbParameters.getZkPath()));
        builder.append("con = engine.connect()\n");
        String executeMode = this.openmldbParameters.getExecuteMode().toLowerCase(Locale.ROOT);
        builder.append("con.execute(\"set @@execute_mode='").append(executeMode).append("';\")\n");
        if (executeMode.equals("offline")) {
            builder.append("con.execute(\"set @@sync_job=true\")\n");
            builder.append("con.execute(\"set @@job_timeout=1800000\")\n");
        }
        Pattern pattern = Pattern.compile("\\S");
        for (String sql : rawSqlScript.split(";")) {
            if (!pattern.matcher(sql).find()) continue;
            sql = sql.replaceAll("\\n", "\\\\n");
            builder.append("con.execute(\"").append(sql).append("\")\n");
        }
        return builder.toString();
    }

    protected String buildPythonExecuteCommand(String pythonFile) {
        Preconditions.checkNotNull((Object)pythonFile, (Object)"Python file cannot be null");
        return this.getPythonCommand() + " " + pythonFile;
    }

    private String getPythonCommand() {
        String pythonHome = System.getenv("PYTHON_HOME");
        return this.getPythonCommand(pythonHome);
    }

    private String getPythonCommand(String pythonHome) {
        if (StringUtils.isEmpty((CharSequence)pythonHome)) {
            return OPENMLDB_PYTHON;
        }
        String pythonBinPath = "/bin/python3";
        Matcher matcher = PYTHON_PATH_PATTERN.matcher(pythonHome);
        if (matcher.find()) {
            return matcher.replaceAll(pythonBinPath);
        }
        return Paths.get(pythonHome, pythonBinPath).toString();
    }
}

