/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.jupyter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParamUtils;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.jupyter.JupyterParameters;

public class JupyterTask
extends AbstractRemoteTask {
    private JupyterParameters jupyterParameters;
    private TaskExecutionContext taskExecutionContext;
    private ShellCommandExecutor shellCommandExecutor;

    public JupyterTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
        this.shellCommandExecutor = new ShellCommandExecutor(arg_0 -> ((JupyterTask)this).logHandle(arg_0), taskExecutionContext, this.logger);
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }

    public void init() {
        this.logger.info("jupyter task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.jupyterParameters = (JupyterParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), JupyterParameters.class));
        if (null == this.jupyterParameters) {
            this.logger.error("jupyter params is null");
            return;
        }
        if (!this.jupyterParameters.checkParameters()) {
            throw new RuntimeException("jupyter task params is not valid");
        }
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        try {
            TaskResponse response = this.shellCommandExecutor.run(this.buildCommand());
            this.setExitStatusCode(response.getExitStatusCode());
            this.setAppIds(String.join((CharSequence)",", this.getApplicationIds()));
            this.setProcessId(response.getProcessId());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.error("The current Jupyter task has been interrupted", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("The current Jupyter task has been interrupted", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("jupyter task execution failure", (Throwable)e);
            this.exitStatusCode = -1;
            throw new TaskException("Execute jupyter task failed", (Throwable)e);
        }
    }

    public void submitApplication() throws TaskException {
    }

    public void trackApplicationStatus() throws TaskException {
    }

    protected String buildCommand() throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        String condaPath = PropertyUtils.getString((String)"conda.path");
        String timestamp = DateUtils.getTimestampString();
        String condaEnvName = this.jupyterParameters.getCondaEnvName();
        if (condaEnvName.endsWith(".txt")) {
            args.add("set +e");
            args.add("\n");
        }
        args.add("source");
        args.add(condaPath);
        args.add("&&");
        if (condaEnvName.endsWith(".tar.gz")) {
            args.add(String.format("mkdir jupyter_env && tar -xzf %s -C jupyter_env && source jupyter_env/bin/activate", condaEnvName));
        } else if (condaEnvName.endsWith(".txt")) {
            args.add(String.format("conda create -n jupyter-tmp-env-%s -y && conda activate jupyter-tmp-env-%s && pip install -r %s", timestamp, timestamp, condaEnvName));
        } else {
            args.add("conda activate");
            args.add(this.jupyterParameters.getCondaEnvName());
        }
        args.add("&&");
        args.add("papermill");
        args.add(this.jupyterParameters.getInputNotePath());
        args.add(this.jupyterParameters.getOutputNotePath());
        args.addAll(this.populateJupyterParameterization());
        args.addAll(this.populateJupyterOptions());
        if (condaEnvName.endsWith(".txt")) {
            args.add("\n");
            args.add(String.format("conda deactivate && conda remove --name jupyter-tmp-env-%s --all -y", timestamp));
        }
        Map paramsMap = this.taskExecutionContext.getPrepareParamsMap();
        String command = ParameterUtils.convertParameterPlaceholders((String)String.join((CharSequence)" ", args), (Map)ParamUtils.convert((Map)paramsMap));
        this.logger.info("jupyter task command: {}", (Object)command);
        return command;
    }

    private List<String> populateJupyterParameterization() throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        String parameters = this.jupyterParameters.getParameters();
        if (StringUtils.isNotEmpty((CharSequence)parameters)) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                Map jupyterParamsMap = (Map)mapper.readValue(parameters, Map.class);
                for (String key : jupyterParamsMap.keySet()) {
                    args.add("--parameters");
                    args.add(key);
                    args.add((String)jupyterParamsMap.get(key));
                }
            }
            catch (IOException e) {
                this.logger.error("fail to parse jupyter parameterization", (Throwable)e);
                throw e;
            }
        }
        return args;
    }

    private List<String> populateJupyterOptions() {
        String others;
        String startTimeout;
        String executionTimeout;
        String engine;
        ArrayList<String> args = new ArrayList<String>();
        String kernel = this.jupyterParameters.getKernel();
        if (StringUtils.isNotEmpty((CharSequence)kernel)) {
            args.add("--kernel");
            args.add(kernel);
        }
        if (StringUtils.isNotEmpty((CharSequence)(engine = this.jupyterParameters.getEngine()))) {
            args.add("--engine");
            args.add(engine);
        }
        if (StringUtils.isNotEmpty((CharSequence)(executionTimeout = this.jupyterParameters.getExecutionTimeout()))) {
            args.add("--execution-timeout");
            args.add(executionTimeout);
        }
        if (StringUtils.isNotEmpty((CharSequence)(startTimeout = this.jupyterParameters.getStartTimeout()))) {
            args.add("--start-timeout");
            args.add(startTimeout);
        }
        if (StringUtils.isNotEmpty((CharSequence)(others = this.jupyterParameters.getOthers()))) {
            args.add(others);
        }
        args.add("--inject-paths");
        args.add("--progress-bar");
        return args;
    }

    public void cancelApplication() throws TaskException {
        try {
            this.shellCommandExecutor.cancelApplication();
        }
        catch (Exception e) {
            throw new TaskException("cancel application error", (Throwable)e);
        }
    }

    public AbstractParameters getParameters() {
        return this.jupyterParameters;
    }
}

