/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.api.utils;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class CommonUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    private static String DEFAULT_DATA_QUALITY_JAR_PATH = null;
    private static final boolean IS_DEVELOP_MODE = PropertyUtils.getBoolean((String)"development.state", (Boolean)true);

    private CommonUtils() {
        throw new UnsupportedOperationException("Construct CommonUtils");
    }

    public static boolean isDevelopMode() {
        return IS_DEVELOP_MODE;
    }

    public static boolean getKerberosStartupState() {
        String resUploadStartupType = PropertyUtils.getUpperCaseString((String)"resource.storage.type");
        ResUploadType resUploadType = ResUploadType.valueOf((String)resUploadStartupType);
        Boolean kerberosStartupState = PropertyUtils.getBoolean((String)"hadoop.security.authentication.startup.state", (Boolean)false);
        return resUploadType == ResUploadType.HDFS && kerberosStartupState != false;
    }

    public static boolean loadKerberosConf(Configuration configuration) throws IOException {
        return CommonUtils.loadKerberosConf(PropertyUtils.getString((String)"java.security.krb5.conf.path"), PropertyUtils.getString((String)"login.user.keytab.username"), PropertyUtils.getString((String)"login.user.keytab.path"), configuration);
    }

    public static synchronized void loadKerberosConf(String javaSecurityKrb5Conf, String loginUserKeytabUsername, String loginUserKeytabPath) throws IOException {
        Configuration configuration = new Configuration();
        configuration.setClassLoader(configuration.getClass().getClassLoader());
        CommonUtils.loadKerberosConf(javaSecurityKrb5Conf, loginUserKeytabUsername, loginUserKeytabPath, configuration);
    }

    public static boolean loadKerberosConf(String javaSecurityKrb5Conf, String loginUserKeytabUsername, String loginUserKeytabPath, Configuration configuration) throws IOException {
        if (CommonUtils.getKerberosStartupState()) {
            System.setProperty("java.security.krb5.conf", (String)StringUtils.defaultIfBlank((CharSequence)javaSecurityKrb5Conf, (CharSequence)PropertyUtils.getString((String)"java.security.krb5.conf.path")));
            configuration.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)configuration);
            UserGroupInformation.loginUserFromKeytab((String)((String)StringUtils.defaultIfBlank((CharSequence)loginUserKeytabUsername, (CharSequence)PropertyUtils.getString((String)"login.user.keytab.username"))), (String)((String)StringUtils.defaultIfBlank((CharSequence)loginUserKeytabPath, (CharSequence)PropertyUtils.getString((String)"login.user.keytab.path"))));
            return true;
        }
        return false;
    }

    public static String getDataQualityJarPath() {
        log.info("Trying to get data quality jar in path");
        String dqJarDir = PropertyUtils.getString((String)"data-quality.jar.dir");
        if (StringUtils.isNotEmpty((CharSequence)dqJarDir)) {
            log.info("Configuration data-quality.jar.dir is not empty, will try to get data quality jar from directory {}", (Object)dqJarDir);
            CommonUtils.getDataQualityJarPathFromPath(dqJarDir).ifPresent(jarName -> {
                DEFAULT_DATA_QUALITY_JAR_PATH = jarName;
            });
        }
        if (StringUtils.isEmpty((CharSequence)DEFAULT_DATA_QUALITY_JAR_PATH)) {
            log.info("data quality jar path is empty, will try to auto discover it from build-in rules.");
            CommonUtils.getDefaultDataQualityJarPath();
        }
        if (StringUtils.isEmpty((CharSequence)DEFAULT_DATA_QUALITY_JAR_PATH)) {
            log.error("Can not find data quality jar in both configuration and auto discover, please check your configuration or report a bug.");
            throw new RuntimeException("data quality jar path is empty");
        }
        return DEFAULT_DATA_QUALITY_JAR_PATH;
    }

    private static String getDefaultDataQualityJarPath() {
        if (StringUtils.isNotEmpty((CharSequence)DEFAULT_DATA_QUALITY_JAR_PATH)) {
            return DEFAULT_DATA_QUALITY_JAR_PATH;
        }
        try {
            String currentAbsolutePath = new ClassPathResource("./").getFile().getAbsolutePath();
            String currentLibPath = currentAbsolutePath + "/../libs";
            CommonUtils.getDataQualityJarPathFromPath(currentLibPath).ifPresent(jarName -> {
                DEFAULT_DATA_QUALITY_JAR_PATH = jarName;
            });
            if (StringUtils.isEmpty((CharSequence)DEFAULT_DATA_QUALITY_JAR_PATH)) {
                log.info("Can not get data quality jar from path {}, maybe service running in standalone mode, will try to find another path", (Object)currentLibPath);
                currentLibPath = currentAbsolutePath + "/../../worker-server/libs";
                CommonUtils.getDataQualityJarPathFromPath(currentLibPath).ifPresent(jarName -> {
                    DEFAULT_DATA_QUALITY_JAR_PATH = jarName;
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException("get default data quality jar path error", e);
        }
        log.info("get default data quality jar name: {}", (Object)DEFAULT_DATA_QUALITY_JAR_PATH);
        return DEFAULT_DATA_QUALITY_JAR_PATH;
    }

    private static Optional<String> getDataQualityJarPathFromPath(String path) {
        log.info("Try to get data quality jar from path {}", (Object)path);
        File[] jars = new File(path).listFiles();
        if (jars == null) {
            log.warn("No any files find given path {}", (Object)path);
            return Optional.empty();
        }
        for (File jar : jars) {
            if (!jar.getName().startsWith("dolphinscheduler-data-quality")) continue;
            return Optional.of(jar.getAbsolutePath());
        }
        log.warn("No data quality related jar found from path {}", (Object)path);
        return Optional.empty();
    }

    public static String getHdfsUdfDir(String tenantCode) {
        return String.format("%s/udfs", CommonUtils.getHdfsTenantDir(tenantCode));
    }

    public static String getHdfsTenantDir(String tenantCode) {
        return String.format("%s/%s", CommonUtils.getHdfsDataBasePath(), tenantCode);
    }

    public static String getHdfsDataBasePath() {
        String resourceUploadPath = PropertyUtils.getString((String)"resource.storage.upload.base.path", (String)"/dolphinscheduler");
        if ("/".equals(resourceUploadPath)) {
            return "";
        }
        return resourceUploadPath;
    }
}

