/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.api.utils;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class CommonUtils {
    private static final boolean IS_DEVELOP_MODE = PropertyUtils.getBoolean((String)"development.state", (Boolean)true);

    private CommonUtils() {
        throw new UnsupportedOperationException("Construct CommonUtils");
    }

    public static boolean isDevelopMode() {
        return IS_DEVELOP_MODE;
    }

    public static boolean getKerberosStartupState() {
        String resUploadStartupType = PropertyUtils.getUpperCaseString((String)"resource.storage.type");
        ResUploadType resUploadType = ResUploadType.valueOf((String)resUploadStartupType);
        Boolean kerberosStartupState = PropertyUtils.getBoolean((String)"hadoop.security.authentication.startup.state", (Boolean)false);
        return resUploadType == ResUploadType.HDFS && kerberosStartupState != false;
    }

    public static boolean loadKerberosConf(Configuration configuration) throws IOException {
        return CommonUtils.loadKerberosConf(PropertyUtils.getString((String)"java.security.krb5.conf.path"), PropertyUtils.getString((String)"login.user.keytab.username"), PropertyUtils.getString((String)"login.user.keytab.path"), configuration);
    }

    public static synchronized void loadKerberosConf(String javaSecurityKrb5Conf, String loginUserKeytabUsername, String loginUserKeytabPath) throws IOException {
        Configuration configuration = new Configuration();
        configuration.setClassLoader(configuration.getClass().getClassLoader());
        CommonUtils.loadKerberosConf(javaSecurityKrb5Conf, loginUserKeytabUsername, loginUserKeytabPath, configuration);
    }

    public static boolean loadKerberosConf(String javaSecurityKrb5Conf, String loginUserKeytabUsername, String loginUserKeytabPath, Configuration configuration) throws IOException {
        if (CommonUtils.getKerberosStartupState()) {
            System.setProperty("java.security.krb5.conf", (String)StringUtils.defaultIfBlank((CharSequence)javaSecurityKrb5Conf, (CharSequence)PropertyUtils.getString((String)"java.security.krb5.conf.path")));
            configuration.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)configuration);
            UserGroupInformation.loginUserFromKeytab((String)((String)StringUtils.defaultIfBlank((CharSequence)loginUserKeytabUsername, (CharSequence)PropertyUtils.getString((String)"login.user.keytab.username"))), (String)((String)StringUtils.defaultIfBlank((CharSequence)loginUserKeytabPath, (CharSequence)PropertyUtils.getString((String)"login.user.keytab.path"))));
            return true;
        }
        return false;
    }

    public static String getDataQualityJarName() {
        String dqsJarName = PropertyUtils.getString((String)"data-quality.jar.name");
        if (StringUtils.isEmpty((CharSequence)dqsJarName)) {
            return "dolphinscheduler-data-quality.jar";
        }
        return dqsJarName;
    }

    public static String getHdfsUdfDir(String tenantCode) {
        return String.format("%s/udfs", CommonUtils.getHdfsTenantDir(tenantCode));
    }

    public static String getHdfsTenantDir(String tenantCode) {
        return String.format("%s/%s", CommonUtils.getHdfsDataBasePath(), tenantCode);
    }

    public static String getHdfsDataBasePath() {
        String resourceUploadPath = PropertyUtils.getString((String)"resource.storage.upload.base.path", (String)"/dolphinscheduler");
        if ("/".equals(resourceUploadPath)) {
            return "";
        }
        return resourceUploadPath;
    }
}

