/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.api.plugin;

import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceProcessorManager {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceProcessorManager.class);
    private static final Map<String, DataSourceProcessor> dataSourceProcessorMap = new ConcurrentHashMap<String, DataSourceProcessor>();

    public Map<String, DataSourceProcessor> getDataSourceProcessorMap() {
        return Collections.unmodifiableMap(dataSourceProcessorMap);
    }

    public void installProcessor() {
        ServiceLoader.load(DataSourceProcessor.class).forEach(factory -> {
            String name = factory.getDbType().name();
            logger.info("start register processor: {}", (Object)name);
            if (dataSourceProcessorMap.containsKey(name)) {
                throw new IllegalStateException(String.format("Duplicate datasource plugins named '%s'", name));
            }
            this.loadDatasourceClient((DataSourceProcessor)factory);
            logger.info("done register processor: {}", (Object)name);
        });
    }

    private void loadDatasourceClient(DataSourceProcessor processor) {
        DataSourceProcessor instance = processor.create();
        dataSourceProcessorMap.put(processor.getDbType().name(), instance);
    }
}

