/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.api.plugin;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.spi.datasource.DataSourceChannel;
import org.apache.dolphinscheduler.spi.datasource.DataSourceChannelFactory;
import org.apache.dolphinscheduler.spi.plugin.PrioritySPIFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourcePluginManager {
    private static final Logger logger = LoggerFactory.getLogger(DataSourcePluginManager.class);
    private final Map<String, DataSourceChannel> datasourceClientMap = new ConcurrentHashMap<String, DataSourceChannel>();

    public Map<String, DataSourceChannel> getDataSourceChannelMap() {
        return Collections.unmodifiableMap(this.datasourceClientMap);
    }

    public void installPlugin() {
        PrioritySPIFactory prioritySPIFactory = new PrioritySPIFactory(DataSourceChannelFactory.class);
        for (Map.Entry entry : prioritySPIFactory.getSPIMap().entrySet()) {
            DataSourceChannelFactory factory = (DataSourceChannelFactory)entry.getValue();
            String name = (String)entry.getKey();
            logger.info("Registering datasource plugin: {}", (Object)name);
            if (this.datasourceClientMap.containsKey(name)) {
                throw new IllegalStateException(String.format("Duplicate datasource plugins named '%s'", name));
            }
            this.loadDatasourceClient(factory);
            logger.info("Registered datasource plugin: {}", (Object)name);
        }
    }

    private void loadDatasourceClient(DataSourceChannelFactory datasourceChannelFactory) {
        DataSourceChannel datasourceChannel = datasourceChannelFactory.create();
        this.datasourceClientMap.put(datasourceChannelFactory.getName(), datasourceChannel);
    }
}

