/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.api.datasource.sqlserver;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.sqlserver.SQLServerConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.sqlserver.SQLServerDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;

public class SQLServerDataSourceProcessor
extends AbstractDataSourceProcessor {
    @Override
    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        SQLServerConnectionParam connectionParams = (SQLServerConnectionParam)this.createConnectionParams(connectionJson);
        String[] hostSeperator = connectionParams.getAddress().split("//");
        String[] hostPortArray = hostSeperator[hostSeperator.length - 1].split(",");
        SQLServerDataSourceParamDTO sqlServerDatasourceParamDTO = new SQLServerDataSourceParamDTO();
        sqlServerDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        sqlServerDatasourceParamDTO.setUserName(connectionParams.getUser());
        sqlServerDatasourceParamDTO.setOther(this.parseOther(connectionParams.getOther()));
        sqlServerDatasourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        sqlServerDatasourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        return sqlServerDatasourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        SQLServerDataSourceParamDTO sqlServerParam = (SQLServerDataSourceParamDTO)datasourceParam;
        String address = String.format("%s%s:%s", "jdbc:sqlserver://", sqlServerParam.getHost(), sqlServerParam.getPort());
        String jdbcUrl = address + ";databaseName=" + sqlServerParam.getDatabase();
        SQLServerConnectionParam sqlServerConnectionParam = new SQLServerConnectionParam();
        sqlServerConnectionParam.setAddress(address);
        sqlServerConnectionParam.setDatabase(sqlServerParam.getDatabase());
        sqlServerConnectionParam.setJdbcUrl(jdbcUrl);
        sqlServerConnectionParam.setOther(this.transformOther(sqlServerParam.getOther()));
        sqlServerConnectionParam.setUser(sqlServerParam.getUserName());
        sqlServerConnectionParam.setPassword(PasswordUtils.encodePassword(sqlServerParam.getPassword()));
        sqlServerConnectionParam.setDriverClassName(this.getDatasourceDriver());
        sqlServerConnectionParam.setValidationQuery(this.getValidationQuery());
        sqlServerConnectionParam.setProps(sqlServerParam.getOther());
        return sqlServerConnectionParam;
    }

    public BaseConnectionParam createConnectionParams(String connectionJson) {
        return (BaseConnectionParam)JSONUtils.parseObject((String)connectionJson, SQLServerConnectionParam.class);
    }

    @Override
    public String getDatasourceDriver() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    public String getValidationQuery() {
        return "select 1";
    }

    @Override
    public String getJdbcUrl(ConnectionParam connectionParam) {
        SQLServerConnectionParam sqlServerConnectionParam = (SQLServerConnectionParam)connectionParam;
        if (!StringUtils.isEmpty((String)sqlServerConnectionParam.getOther())) {
            return String.format("%s;%s", sqlServerConnectionParam.getJdbcUrl(), sqlServerConnectionParam.getOther());
        }
        return sqlServerConnectionParam.getJdbcUrl();
    }

    @Override
    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        SQLServerConnectionParam sqlServerConnectionParam = (SQLServerConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), sqlServerConnectionParam.getUser(), PasswordUtils.decodePassword(sqlServerConnectionParam.getPassword()));
    }

    @Override
    public DbType getDbType() {
        return DbType.SQLSERVER;
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        otherMap.forEach((key, value) -> stringBuilder.append(String.format("%s=%s;", key, value)));
        return stringBuilder.toString();
    }

    private Map<String, String> parseOther(String other) {
        if (StringUtils.isEmpty((String)other)) {
            return null;
        }
        LinkedHashMap<String, String> otherMap = new LinkedHashMap<String, String>();
        for (String config : other.split(";")) {
            otherMap.put(config.split("=")[0], config.split("=")[1]);
        }
        return otherMap;
    }
}

