/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.api.datasource.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.mysql.MySQLConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.mysql.MySQLDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLDataSourceProcessor
extends AbstractDataSourceProcessor {
    private final Logger logger = LoggerFactory.getLogger(MySQLDataSourceProcessor.class);
    private static final String ALLOW_LOAD_LOCAL_IN_FILE_NAME = "allowLoadLocalInfile";
    private static final String AUTO_DESERIALIZE = "autoDeserialize";
    private static final String ALLOW_LOCAL_IN_FILE_NAME = "allowLocalInfile";
    private static final String ALLOW_URL_IN_LOCAL_IN_FILE_NAME = "allowUrlInLocalInfile";
    private static final String APPEND_PARAMS = "allowLoadLocalInfile=false&autoDeserialize=false&allowLocalInfile=false&allowUrlInLocalInfile=false";

    @Override
    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        MySQLConnectionParam connectionParams = (MySQLConnectionParam)this.createConnectionParams(connectionJson);
        MySQLDataSourceParamDTO mysqlDatasourceParamDTO = new MySQLDataSourceParamDTO();
        mysqlDatasourceParamDTO.setUserName(connectionParams.getUser());
        mysqlDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        mysqlDatasourceParamDTO.setOther(this.parseOther(connectionParams.getOther()));
        String address = connectionParams.getAddress();
        String[] hostSeperator = address.split("//");
        String[] hostPortArray = hostSeperator[hostSeperator.length - 1].split(",");
        mysqlDatasourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        mysqlDatasourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        return mysqlDatasourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO dataSourceParam) {
        MySQLDataSourceParamDTO mysqlDatasourceParam = (MySQLDataSourceParamDTO)dataSourceParam;
        String address = String.format("%s%s:%s", "jdbc:mysql://", mysqlDatasourceParam.getHost(), mysqlDatasourceParam.getPort());
        String jdbcUrl = String.format("%s/%s", address, mysqlDatasourceParam.getDatabase());
        MySQLConnectionParam mysqlConnectionParam = new MySQLConnectionParam();
        mysqlConnectionParam.setJdbcUrl(jdbcUrl);
        mysqlConnectionParam.setDatabase(mysqlDatasourceParam.getDatabase());
        mysqlConnectionParam.setAddress(address);
        mysqlConnectionParam.setUser(mysqlDatasourceParam.getUserName());
        mysqlConnectionParam.setPassword(PasswordUtils.encodePassword(mysqlDatasourceParam.getPassword()));
        mysqlConnectionParam.setDriverClassName(this.getDatasourceDriver());
        mysqlConnectionParam.setValidationQuery(this.getValidationQuery());
        mysqlConnectionParam.setOther(this.transformOther(mysqlDatasourceParam.getOther()));
        mysqlConnectionParam.setProps(mysqlDatasourceParam.getOther());
        return mysqlConnectionParam;
    }

    @Override
    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, MySQLConnectionParam.class);
    }

    @Override
    public String getDatasourceDriver() {
        return "com.mysql.cj.jdbc.Driver";
    }

    @Override
    public String getValidationQuery() {
        return "select 1";
    }

    @Override
    public String getJdbcUrl(ConnectionParam connectionParam) {
        MySQLConnectionParam mysqlConnectionParam = (MySQLConnectionParam)connectionParam;
        String jdbcUrl = mysqlConnectionParam.getJdbcUrl();
        if (!StringUtils.isEmpty((CharSequence)mysqlConnectionParam.getOther())) {
            return String.format("%s?%s&%s", jdbcUrl, mysqlConnectionParam.getOther(), APPEND_PARAMS);
        }
        return String.format("%s?%s", jdbcUrl, APPEND_PARAMS);
    }

    @Override
    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        String password;
        MySQLConnectionParam mysqlConnectionParam = (MySQLConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        String user = mysqlConnectionParam.getUser();
        if (user.contains(AUTO_DESERIALIZE)) {
            this.logger.warn("sensitive param : {} in username field is filtered", (Object)AUTO_DESERIALIZE);
            user = user.replace(AUTO_DESERIALIZE, "");
        }
        if ((password = PasswordUtils.decodePassword(mysqlConnectionParam.getPassword())).contains(AUTO_DESERIALIZE)) {
            this.logger.warn("sensitive param : {} in password field is filtered", (Object)AUTO_DESERIALIZE);
            password = password.replace(AUTO_DESERIALIZE, "");
        }
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), user, password);
    }

    @Override
    public DbType getDbType() {
        return DbType.MYSQL;
    }

    private String transformOther(Map<String, String> paramMap) {
        if (MapUtils.isEmpty(paramMap)) {
            return null;
        }
        HashMap<String, String> otherMap = new HashMap<String, String>();
        paramMap.forEach((k, v) -> {
            if (!MySQLDataSourceProcessor.checkKeyIsLegitimate(k)) {
                return;
            }
            otherMap.put((String)k, (String)v);
        });
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        otherMap.forEach((key, value) -> stringBuilder.append(String.format("%s=%s&", key, value)));
        return stringBuilder.toString();
    }

    private static boolean checkKeyIsLegitimate(String key) {
        return !key.contains(ALLOW_LOAD_LOCAL_IN_FILE_NAME) && !key.contains(AUTO_DESERIALIZE) && !key.contains(ALLOW_LOCAL_IN_FILE_NAME) && !key.contains(ALLOW_URL_IN_LOCAL_IN_FILE_NAME);
    }

    private Map<String, String> parseOther(String other) {
        if (StringUtils.isEmpty((CharSequence)other)) {
            return null;
        }
        LinkedHashMap<String, String> otherMap = new LinkedHashMap<String, String>();
        for (String config : other.split("&")) {
            otherMap.put(config.split("=")[0], config.split("=")[1]);
        }
        return otherMap;
    }
}

