/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.api.client;

import com.google.common.base.Stopwatch;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.dolphinscheduler.plugin.datasource.api.provider.JDBCDataSourceProvider;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.DataSourceClient;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class CommonDataSourceClient
implements DataSourceClient {
    private static final Logger logger = LoggerFactory.getLogger(CommonDataSourceClient.class);
    public static final String COMMON_USER = "root";
    public static final String COMMON_VALIDATION_QUERY = "select 1";
    protected final BaseConnectionParam baseConnectionParam;
    protected HikariDataSource dataSource;
    protected JdbcTemplate jdbcTemplate;

    public CommonDataSourceClient(BaseConnectionParam baseConnectionParam, DbType dbType) {
        this.baseConnectionParam = baseConnectionParam;
        this.preInit();
        this.checkEnv(baseConnectionParam);
        this.initClient(baseConnectionParam, dbType);
        this.checkClient();
    }

    protected void preInit() {
        logger.info("preInit in CommonDataSourceClient");
    }

    protected void checkEnv(BaseConnectionParam baseConnectionParam) {
        this.checkValidationQuery(baseConnectionParam);
        this.checkUser(baseConnectionParam);
    }

    protected void initClient(BaseConnectionParam baseConnectionParam, DbType dbType) {
        this.dataSource = JDBCDataSourceProvider.createJdbcDataSource(baseConnectionParam, dbType);
        this.jdbcTemplate = new JdbcTemplate((DataSource)this.dataSource);
    }

    protected void checkUser(BaseConnectionParam baseConnectionParam) {
        if (StringUtils.isBlank((CharSequence)baseConnectionParam.getUser())) {
            this.setDefaultUsername(baseConnectionParam);
        }
    }

    protected void setDefaultUsername(BaseConnectionParam baseConnectionParam) {
        baseConnectionParam.setUser(COMMON_USER);
    }

    protected void checkValidationQuery(BaseConnectionParam baseConnectionParam) {
        if (StringUtils.isBlank((CharSequence)baseConnectionParam.getValidationQuery())) {
            this.setDefaultValidationQuery(baseConnectionParam);
        }
    }

    protected void setDefaultValidationQuery(BaseConnectionParam baseConnectionParam) {
        baseConnectionParam.setValidationQuery(COMMON_VALIDATION_QUERY);
    }

    public void checkClient() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.jdbcTemplate.execute(this.baseConnectionParam.getValidationQuery());
        }
        catch (Exception e) {
            throw new RuntimeException("JDBC connect failed", e);
        }
        finally {
            logger.info("Time to execute check jdbc client with sql {} for {} ms ", (Object)this.baseConnectionParam.getValidationQuery(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            logger.error("get druidDataSource Connection fail SQLException: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public void close() {
        logger.info("do close dataSource {}.", (Object)this.baseConnectionParam.getDatabase());
        HikariDataSource closedDatasource = this.dataSource;
        Throwable throwable = null;
        if (closedDatasource != null) {
            if (throwable != null) {
                try {
                    closedDatasource.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                closedDatasource.close();
            }
        }
        this.jdbcTemplate = null;
    }
}

