/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.TenantService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"TENANT_TAG"})
@RestController
@RequestMapping(value={"/tenants"})
public class TenantController
extends BaseController {
    @Autowired
    private TenantService tenantService;

    @ApiOperation(value="createTenant", notes="CREATE_TENANT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tenantCode", value="TENANT_CODE", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="queueId", value="QUEUE_ID", required=true, dataTypeClass=int.class, example="100"), @ApiImplicitParam(name="description", value="TENANT_DESC", dataTypeClass=String.class)})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_TENANT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createTenant(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="tenantCode") String tenantCode, @RequestParam(value="queueId") int queueId, @RequestParam(value="description", required=false) String description) throws Exception {
        Map<String, Object> result = this.tenantService.createTenant(loginUser, tenantCode, queueId, description);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryTenantlistPaging", notes="QUERY_TENANT_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataTypeClass=String.class), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataTypeClass=int.class, example="20")})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TENANT_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTenantlistPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.tenantService.queryTenantList(loginUser, searchVal, pageNo, pageSize);
        return result;
    }

    @ApiOperation(value="queryTenantlist", notes="QUERY_TENANT_LIST_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TENANT_LIST_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTenantlist(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.tenantService.queryTenantList(loginUser);
        return this.returnDataList(result);
    }

    @ApiOperation(value="updateTenant", notes="UPDATE_TENANT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="TENANT_ID", required=true, dataTypeClass=int.class, example="100"), @ApiImplicitParam(name="tenantCode", value="TENANT_CODE", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="queueId", value="QUEUE_ID", required=true, dataTypeClass=int.class, example="100"), @ApiImplicitParam(name="description", value="TENANT_DESC", dataTypeClass=String.class)})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_TENANT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateTenant(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id, @RequestParam(value="tenantCode") String tenantCode, @RequestParam(value="queueId") int queueId, @RequestParam(value="description", required=false) String description) throws Exception {
        Map<String, Object> result = this.tenantService.updateTenant(loginUser, id, tenantCode, queueId, description);
        return this.returnDataList(result);
    }

    @ApiOperation(value="deleteTenantById", notes="DELETE_TENANT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="TENANT_ID", required=true, dataTypeClass=int.class, example="100")})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TENANT_BY_ID_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteTenantById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) throws Exception {
        Map<String, Object> result = this.tenantService.deleteTenantById(loginUser, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="verifyTenantCode", notes="VERIFY_TENANT_CODE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tenantCode", value="TENANT_CODE", required=true, dataTypeClass=String.class)})
    @GetMapping(value={"/verify-code"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_OS_TENANT_CODE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result verifyTenantCode(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="tenantCode") String tenantCode) {
        return this.tenantService.verifyTenantCode(tenantCode);
    }
}

