/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.utils.Result;

public class BaseController {
    public Result checkPageParams(int pageNo, int pageSize) {
        Result result = new Result();
        Status resultEnum = Status.SUCCESS;
        String msg = Status.SUCCESS.getMsg();
        if (pageNo <= 0) {
            resultEnum = Status.REQUEST_PARAMS_NOT_VALID_ERROR;
            msg = MessageFormat.format(Status.REQUEST_PARAMS_NOT_VALID_ERROR.getMsg(), "pageNo");
        } else if (pageSize <= 0) {
            resultEnum = Status.REQUEST_PARAMS_NOT_VALID_ERROR;
            msg = MessageFormat.format(Status.REQUEST_PARAMS_NOT_VALID_ERROR.getMsg(), "pageSize");
        }
        result.setCode(resultEnum.getCode());
        result.setMsg(msg);
        return result;
    }

    public static String getClientIpAddress(HttpServletRequest request) {
        String clientIp = request.getHeader("X-Forwarded-For");
        if (StringUtils.isNotEmpty((CharSequence)clientIp) && !clientIp.equalsIgnoreCase("unKnown")) {
            int index = clientIp.indexOf(",");
            if (index != -1) {
                return clientIp.substring(0, index);
            }
            return clientIp;
        }
        clientIp = request.getHeader("X-Real-IP");
        if (StringUtils.isNotEmpty((CharSequence)clientIp) && !clientIp.equalsIgnoreCase("unKnown")) {
            return clientIp;
        }
        return request.getRemoteAddr();
    }

    public Result returnDataList(Map<String, Object> result) {
        Status status = (Status)((Object)result.get("status"));
        if (status == Status.SUCCESS) {
            String msg = Status.SUCCESS.getMsg();
            Object datalist = result.get("data");
            return this.success(msg, datalist);
        }
        Integer code = status.getCode();
        String msg = (String)result.get("msg");
        return this.error(code, msg);
    }

    public Result success() {
        Result result = new Result();
        result.setCode(Status.SUCCESS.getCode());
        result.setMsg(Status.SUCCESS.getMsg());
        return result;
    }

    public Result success(String msg) {
        Result result = new Result();
        result.setCode(Status.SUCCESS.getCode());
        result.setMsg(msg);
        return result;
    }

    public Result success(String msg, Object list) {
        return this.getResult(msg, list);
    }

    public Result success(Object list) {
        return this.getResult(Status.SUCCESS.getMsg(), list);
    }

    public Result success(String msg, Map<String, Object> object) {
        return this.getResult(msg, object);
    }

    public Result success(Object totalList, Integer currentPage, Integer total, Integer totalPage) {
        Result result = new Result();
        result.setCode(Status.SUCCESS.getCode());
        result.setMsg(Status.SUCCESS.getMsg());
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("totalList", totalList);
        map.put("currentPage", currentPage);
        map.put("totalPage", totalPage);
        map.put("total", total);
        result.setData(map);
        return result;
    }

    public Result error(Integer code, String msg) {
        Result result = new Result();
        result.setCode(code);
        result.setMsg(msg);
        return result;
    }

    protected void putMsg(Map<String, Object> result, Status status, Object ... statusParams) {
        result.put("status", (Object)status);
        if (statusParams != null && statusParams.length > 0) {
            result.put("msg", MessageFormat.format(status.getMsg(), statusParams));
        } else {
            result.put("msg", status.getMsg());
        }
    }

    protected void putMsg(Result result, Status status, Object ... statusParams) {
        result.setCode(status.getCode());
        if (statusParams != null && statusParams.length > 0) {
            result.setMsg(MessageFormat.format(status.getMsg(), statusParams));
        } else {
            result.setMsg(status.getMsg());
        }
    }

    private Result getResult(String msg, Object list) {
        Result<Object> result = new Result<Object>();
        result.setCode(Status.SUCCESS.getCode());
        result.setMsg(msg);
        result.setData(list);
        return result;
    }
}

