/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.dolphinscheduler.api.configuration.TaskTypeConfiguration;
import org.apache.dolphinscheduler.api.dto.FavTaskDto;
import org.apache.dolphinscheduler.api.service.FavTaskService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.dao.entity.FavTask;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.FavTaskMapper;
import org.springframework.stereotype.Service;

@Service
public class FavTaskServiceImpl
extends BaseServiceImpl
implements FavTaskService {
    @Resource
    private TaskTypeConfiguration taskTypeConfiguration;
    @Resource
    private FavTaskMapper favMapper;

    @Override
    public List<FavTaskDto> getFavTaskList(User loginUser) {
        ArrayList<FavTaskDto> result = new ArrayList<FavTaskDto>();
        Set userFavTaskTypes = this.favMapper.getUserFavTaskTypes(loginUser.getId().intValue());
        Set<FavTaskDto> defaultTaskTypes = this.taskTypeConfiguration.getDefaultTaskTypes();
        defaultTaskTypes.forEach(e -> {
            if (userFavTaskTypes.contains(e.getTaskName())) {
                e.setCollection(true);
            }
            result.add((FavTaskDto)e);
        });
        return result;
    }

    @Override
    public boolean deleteFavTask(User loginUser, String taskName) {
        return this.favMapper.deleteUserFavTask(loginUser.getId().intValue(), taskName);
    }

    @Override
    public int addFavTask(User loginUser, String taskName) {
        this.favMapper.deleteUserFavTask(loginUser.getId().intValue(), taskName);
        return this.favMapper.insert((Object)new FavTask(null, taskName, loginUser.getId().intValue()));
    }
}

