/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto.resources;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.spi.enums.ResourceType;

@JsonPropertyOrder(value={"id", "pid", "name", "fullName", "description", "isDirctory", "children", "type"})
public abstract class ResourceComponent {
    protected int id;
    protected int pid;
    protected String name;
    protected String currentDir;
    protected String fullName;
    protected String description;
    protected boolean isDirctory;
    protected String idValue;
    protected ResourceType type;
    protected List<ResourceComponent> children = new ArrayList<ResourceComponent>();

    public ResourceComponent(int id, int pid, String name, String fullName, String description, boolean isDirctory) {
        this.id = id;
        this.pid = pid;
        this.name = name;
        this.fullName = fullName;
        this.description = description;
        this.isDirctory = isDirctory;
        int directoryFlag = isDirctory ? 1 : 0;
        this.idValue = String.format("%s_%s", id, directoryFlag);
    }

    public void add(ResourceComponent resourceComponent) {
        this.children.add(resourceComponent);
    }

    public void setIdValue(int id, boolean isDirctory) {
        int directoryFlag = isDirctory ? 1 : 0;
        this.idValue = String.format("%s_%s", id, directoryFlag);
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public int getPid() {
        return this.pid;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getCurrentDir() {
        return this.currentDir;
    }

    @Generated
    public String getFullName() {
        return this.fullName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isDirctory() {
        return this.isDirctory;
    }

    @Generated
    public String getIdValue() {
        return this.idValue;
    }

    @Generated
    public ResourceType getType() {
        return this.type;
    }

    @Generated
    public List<ResourceComponent> getChildren() {
        return this.children;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public void setPid(int pid) {
        this.pid = pid;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCurrentDir(String currentDir) {
        this.currentDir = currentDir;
    }

    @Generated
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDirctory(boolean isDirctory) {
        this.isDirctory = isDirctory;
    }

    @Generated
    public void setIdValue(String idValue) {
        this.idValue = idValue;
    }

    @Generated
    public void setType(ResourceType type) {
        this.type = type;
    }

    @Generated
    public void setChildren(List<ResourceComponent> children) {
        this.children = children;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceComponent)) {
            return false;
        }
        ResourceComponent other = (ResourceComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getPid() != other.getPid()) {
            return false;
        }
        if (this.isDirctory() != other.isDirctory()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$currentDir = this.getCurrentDir();
        String other$currentDir = other.getCurrentDir();
        if (this$currentDir == null ? other$currentDir != null : !this$currentDir.equals(other$currentDir)) {
            return false;
        }
        String this$fullName = this.getFullName();
        String other$fullName = other.getFullName();
        if (this$fullName == null ? other$fullName != null : !this$fullName.equals(other$fullName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$idValue = this.getIdValue();
        String other$idValue = other.getIdValue();
        if (this$idValue == null ? other$idValue != null : !this$idValue.equals(other$idValue)) {
            return false;
        }
        ResourceType this$type = this.getType();
        ResourceType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<ResourceComponent> this$children = this.getChildren();
        List<ResourceComponent> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResourceComponent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getPid();
        result = result * 59 + (this.isDirctory() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $currentDir = this.getCurrentDir();
        result = result * 59 + ($currentDir == null ? 43 : $currentDir.hashCode());
        String $fullName = this.getFullName();
        result = result * 59 + ($fullName == null ? 43 : $fullName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $idValue = this.getIdValue();
        result = result * 59 + ($idValue == null ? 43 : $idValue.hashCode());
        ResourceType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<ResourceComponent> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResourceComponent(id=" + this.getId() + ", pid=" + this.getPid() + ", name=" + this.getName() + ", currentDir=" + this.getCurrentDir() + ", fullName=" + this.getFullName() + ", description=" + this.getDescription() + ", isDirctory=" + this.isDirctory() + ", idValue=" + this.getIdValue() + ", type=" + this.getType() + ", children=" + this.getChildren() + ")";
    }

    @Generated
    public ResourceComponent() {
    }
}

