/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.dto.project.ProjectCreateRequest;
import org.apache.dolphinscheduler.api.dto.project.ProjectCreateResponse;
import org.apache.dolphinscheduler.api.dto.project.ProjectDeleteResponse;
import org.apache.dolphinscheduler.api.dto.project.ProjectListPagingResponse;
import org.apache.dolphinscheduler.api.dto.project.ProjectListResponse;
import org.apache.dolphinscheduler.api.dto.project.ProjectQueryRequest;
import org.apache.dolphinscheduler.api.dto.project.ProjectQueryResponse;
import org.apache.dolphinscheduler.api.dto.project.ProjectUpdateRequest;
import org.apache.dolphinscheduler.api.dto.project.ProjectUpdateResponse;
import org.apache.dolphinscheduler.api.dto.user.UserListResponse;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"PROJECT_TAG"})
@RestController
@RequestMapping(value={"/v2/projects"})
public class ProjectV2Controller
extends BaseController {
    @Autowired
    private ProjectService projectService;

    @ApiOperation(value="create", notes="CREATE_PROJECT_NOTES")
    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_PROJECT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public ProjectCreateResponse createProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestBody ProjectCreateRequest projectCreateRequest) {
        Result result = this.projectService.createProject(loginUser, projectCreateRequest.getProjectName(), projectCreateRequest.getDescription());
        return new ProjectCreateResponse(result);
    }

    @ApiOperation(value="update", notes="UPDATE_PROJECT_NOTES")
    @PutMapping(value={"/{code}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_PROJECT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public ProjectUpdateResponse updateProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code") Long code, @RequestBody ProjectUpdateRequest projectUpdateReq) {
        Result result = this.projectService.update(loginUser, code, projectUpdateReq.getProjectName(), projectUpdateReq.getDescription(), projectUpdateReq.getUserName());
        return new ProjectUpdateResponse(result);
    }

    @ApiOperation(value="queryProjectByCode", notes="QUERY_PROJECT_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="PROJECT_CODE", dataTypeClass=long.class, example="123456", required=true)})
    @GetMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROJECT_DETAILS_BY_CODE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public ProjectQueryResponse queryProjectByCode(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code") long code) {
        Result result = this.projectService.queryByCode(loginUser, code);
        return new ProjectQueryResponse(result);
    }

    @ApiOperation(value="queryProjectListPaging", notes="QUERY_PROJECT_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataTypeClass=String.class, example="test"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataTypeClass=int.class, example="10"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataTypeClass=int.class, example="1")})
    @GetMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public ProjectListPagingResponse queryProjectListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, ProjectQueryRequest projectQueryReq) {
        Result result = this.checkPageParams(projectQueryReq.getPageNo(), projectQueryReq.getPageSize());
        if (!result.checkResult().booleanValue()) {
            return new ProjectListPagingResponse(result);
        }
        String searchVal = ParameterUtils.handleEscapes((String)projectQueryReq.getSearchVal());
        result = this.projectService.queryProjectListPaging(loginUser, projectQueryReq.getPageSize(), projectQueryReq.getPageNo(), searchVal);
        return new ProjectListPagingResponse(result);
    }

    @ApiOperation(value="delete", notes="DELETE_PROJECT_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="PROJECT_CODE", dataTypeClass=long.class, example="123456", required=true)})
    @DeleteMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_PROJECT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public ProjectDeleteResponse deleteProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code") Long code) {
        Result result = this.projectService.deleteProject(loginUser, code);
        return new ProjectDeleteResponse(result);
    }

    @ApiOperation(value="queryUnauthorizedProject", notes="QUERY_UNAUTHORIZED_PROJECT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", dataTypeClass=int.class, example="100", required=true)})
    @GetMapping(value={"/unauth-project"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_UNAUTHORIZED_PROJECT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public ProjectListResponse queryUnauthorizedProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        Result result = this.projectService.queryUnauthorizedProject(loginUser, userId);
        return new ProjectListResponse(result);
    }

    @ApiOperation(value="queryAuthorizedProject", notes="QUERY_AUTHORIZED_PROJECT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", dataTypeClass=int.class, example="100", required=true)})
    @GetMapping(value={"/authed-project"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_AUTHORIZED_PROJECT)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public ProjectListResponse queryAuthorizedProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        Result result = this.projectService.queryAuthorizedProject(loginUser, userId);
        return new ProjectListResponse(result);
    }

    @ApiOperation(value="queryAuthorizedUser", notes="QUERY_AUTHORIZED_USER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", dataTypeClass=long.class, example="100", required=true)})
    @GetMapping(value={"/authed-user"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_AUTHORIZED_USER)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public UserListResponse queryAuthorizedUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="projectCode") Long projectCode) {
        Result result = this.projectService.queryAuthorizedUser(loginUser, projectCode);
        return new UserListResponse(result);
    }

    @ApiOperation(value="queryProjectCreatedAndAuthorizedByUser", notes="QUERY_AUTHORIZED_AND_USER_CREATED_PROJECT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="loginUser", value="LOGIN_USER", dataTypeClass=Object.class, example="\"{id:100}\"", required=true)})
    @GetMapping(value={"/created-and-authed"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_AUTHORIZED_AND_USER_CREATED_PROJECT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public ProjectListResponse queryProjectCreatedAndAuthorizedByUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        Result result = this.projectService.queryProjectCreatedAndAuthorizedByUser(loginUser);
        return new ProjectListResponse(result);
    }

    @ApiOperation(value="queryAllProjectList", notes="QUERY_ALL_PROJECT_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="loginUser", value="LOGIN_USER", dataTypeClass=Object.class, example="\"{id:100}\"", required=true)})
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public ProjectListResponse queryAllProjectList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        Result result = this.projectService.queryAllProjectList(loginUser);
        return new ProjectListResponse(result);
    }

    @ApiOperation(value="queryAllProjectListForDependent", notes="QUERY_ALL_PROJECT_LIST_FOR_DEPENDENT_NOTES")
    @GetMapping(value={"/list-dependent"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public ProjectListResponse queryAllProjectListForDependent(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        Result result = this.projectService.queryAllProjectListForDependent();
        return new ProjectListResponse(result);
    }
}

