/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ProcessTaskRelationService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"PROCESS_TASK_RELATION_TAG"})
@RestController
@RequestMapping(value={"projects/{projectCode}/process-task-relation"})
public class ProcessTaskRelationController
extends BaseController {
    @Autowired
    private ProcessTaskRelationService processTaskRelationService;

    @ApiOperation(value="save", notes="CREATE_PROCESS_TASK_RELATION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="processDefinitionCode", value="PROCESS_DEFINITION_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="preTaskCode", value="PRE_TASK_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="postTaskCode", value="POST_TASK_CODE", required=true, dataTypeClass=long.class)})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_PROCESS_TASK_RELATION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createProcessTaskRelation(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(name="processDefinitionCode", required=true) long processDefinitionCode, @RequestParam(name="preTaskCode", required=true) long preTaskCode, @RequestParam(name="postTaskCode", required=true) long postTaskCode) {
        Map<String, Object> result = new HashMap<String, Object>();
        if (postTaskCode == 0L) {
            this.putMsg(result, Status.DATA_IS_NOT_VALID, "postTaskCode");
        } else if (processDefinitionCode == 0L) {
            this.putMsg(result, Status.DATA_IS_NOT_VALID, "processDefinitionCode");
        } else {
            result = this.processTaskRelationService.createProcessTaskRelation(loginUser, projectCode, processDefinitionCode, preTaskCode, postTaskCode);
        }
        return this.returnDataList(result);
    }

    @ApiOperation(value="deleteRelation", notes="DELETE_PROCESS_TASK_RELATION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="processDefinitionCode", value="PROCESS_DEFINITION_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="taskCode", value="TASK_CODE", required=true, dataTypeClass=long.class)})
    @DeleteMapping(value={"/{taskCode}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TASK_PROCESS_RELATION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteTaskProcessRelation(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(name="processDefinitionCode", required=true) long processDefinitionCode, @PathVariable(value="taskCode") long taskCode) {
        return this.returnDataList(this.processTaskRelationService.deleteTaskProcessRelation(loginUser, projectCode, processDefinitionCode, taskCode));
    }

    @ApiOperation(value="deleteUpstreamRelation", notes="DELETE_UPSTREAM_RELATION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="preTaskCodes", value="PRE_TASK_CODES", required=true, dataTypeClass=String.class, example="1,2"), @ApiImplicitParam(name="taskCode", value="TASK_CODE", required=true, dataTypeClass=long.class)})
    @DeleteMapping(value={"/{taskCode}/upstream"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TASK_PROCESS_RELATION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteUpstreamRelation(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(name="preTaskCodes", required=true) String preTaskCodes, @PathVariable(value="taskCode") long taskCode) {
        return this.returnDataList(this.processTaskRelationService.deleteUpstreamRelation(loginUser, projectCode, preTaskCodes, taskCode));
    }

    @ApiOperation(value="deleteDownstreamRelation", notes="DELETE_DOWNSTREAM_RELATION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="postTaskCodes", value="POST_TASK_CODES", required=true, dataTypeClass=String.class, example="1,2"), @ApiImplicitParam(name="taskCode", value="TASK_CODE", required=true, dataTypeClass=long.class)})
    @DeleteMapping(value={"/{taskCode}/downstream"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TASK_PROCESS_RELATION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteDownstreamRelation(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(name="postTaskCodes", required=true) String postTaskCodes, @PathVariable(value="taskCode") long taskCode) {
        return this.returnDataList(this.processTaskRelationService.deleteDownstreamRelation(loginUser, projectCode, postTaskCodes, taskCode));
    }

    @ApiOperation(value="queryUpstreamRelation", notes="QUERY_UPSTREAM_RELATION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="taskCode", value="TASK_CODE", required=true, dataTypeClass=long.class)})
    @GetMapping(value={"/{taskCode}/upstream"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_PROCESS_RELATION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryUpstreamRelation(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="taskCode") long taskCode) {
        return this.returnDataList(this.processTaskRelationService.queryUpstreamRelation(loginUser, projectCode, taskCode));
    }

    @ApiOperation(value="queryDownstreamRelation", notes="QUERY_DOWNSTREAM_RELATION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="taskCode", value="TASK_CODE", required=true, dataTypeClass=long.class)})
    @GetMapping(value={"/{taskCode}/downstream"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_PROCESS_RELATION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryDownstreamRelation(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="taskCode") long taskCode) {
        return this.returnDataList(this.processTaskRelationService.queryDownstreamRelation(loginUser, projectCode, taskCode));
    }

    @ApiOperation(value="deleteEdge", notes="DELETE_EDGE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="processDefinitionCode", value="PROCESS_DEFINITION_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="preTaskCode", value="PRE_TASK_CODE", required=true, dataTypeClass=long.class), @ApiImplicitParam(name="postTaskCode", value="POST_TASK_CODE", required=true, dataTypeClass=long.class)})
    @DeleteMapping(value={"/{processDefinitionCode}/{preTaskCode}/{postTaskCode}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_EDGE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteEdge(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable long processDefinitionCode, @PathVariable long preTaskCode, @PathVariable long postTaskCode) {
        return this.returnDataList(this.processTaskRelationService.deleteEdge(loginUser, projectCode, processDefinitionCode, preTaskCode, postTaskCode));
    }
}

