/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.dto.FavTaskDto;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.FavTaskService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"FAVOURITE"})
@RestController
@RequestMapping(value={"/favourite"})
public class FavTaskController
extends BaseController {
    @Resource
    private FavTaskService favTaskService;

    @ApiOperation(value="listTaskType", notes="QUERY_TASK_TYPE_LIST")
    @GetMapping(value={"/taskTypes"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_TASK_TYPE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result listTaskType(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        List<FavTaskDto> favTaskList = this.favTaskService.getFavTaskList(loginUser);
        return this.success(Status.SUCCESS.getMsg(), favTaskList);
    }

    @ApiOperation(value="deleteTaskType", notes="DELETE_TASK_TYPE")
    @DeleteMapping(value={"/{taskName}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TASK_TYPE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteFavTask(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="taskName") String taskName) {
        boolean b = this.favTaskService.deleteFavTask(loginUser, taskName);
        return this.success(b);
    }

    @ApiOperation(value="addTaskType", notes="ADD_TASK_TYPE")
    @PostMapping(value={"/{taskName}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.ADD_TASK_TYPE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result addFavTask(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="taskName") String taskName) {
        int i = this.favTaskService.addFavTask(loginUser, taskName);
        return this.success(i > 0);
    }
}

