/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.AuditService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuditOperationType;
import org.apache.dolphinscheduler.common.enums.AuditResourceType;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"AUDIT_LOG_TAG"})
@RestController
@RequestMapping(value={"projects/audit"})
public class AuditLogController
extends BaseController {
    @Autowired
    AuditService auditService;

    @ApiOperation(value="queryAuditLogListPaging", notes="QUERY_AUDIT_LOG")
    @ApiImplicitParams(value={@ApiImplicitParam(name="startDate", value="START_DATE", dataTypeClass=String.class), @ApiImplicitParam(name="endDate", value="END_DATE", dataTypeClass=String.class), @ApiImplicitParam(name="resourceType", value="RESOURCE_TYPE", dataTypeClass=AuditResourceType.class), @ApiImplicitParam(name="operationType", value="OPERATION_TYPE", dataTypeClass=AuditOperationType.class), @ApiImplicitParam(name="userName", value="USER_NAME", dataTypeClass=String.class), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataTypeClass=int.class, example="20")})
    @GetMapping(value={"/audit-log-list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_AUDIT_LOG_LIST_PAGING)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAuditLogListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="resourceType", required=false) AuditResourceType resourceType, @RequestParam(value="operationType", required=false) AuditOperationType operationType, @RequestParam(value="startDate", required=false) String startDate, @RequestParam(value="endDate", required=false) String endDate, @RequestParam(value="userName", required=false) String userName) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        result = this.auditService.queryLogListPaging(loginUser, resourceType, operationType, startDate, endDate, userName, pageNo, pageSize);
        return result;
    }
}

