/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.views;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.apacheds.model.Server;
import org.apache.directory.studio.apacheds.model.ServerEvent;
import org.apache.directory.studio.apacheds.model.ServerEventEnum;
import org.apache.directory.studio.apacheds.model.ServerListener;
import org.apache.directory.studio.apacheds.model.ServerStateEnum;
import org.apache.directory.studio.apacheds.model.ServersHandler;
import org.apache.directory.studio.apacheds.model.ServersHandlerListener;
import org.apache.directory.studio.apacheds.views.ServersViewContentProvider;
import org.apache.directory.studio.apacheds.views.ServersViewLabelProvider;
import org.apache.directory.studio.apacheds.views.ServersViewerComparator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ServersTableViewer
extends TreeViewer {
    protected static final String ROOT = "root";
    private ServersViewLabelProvider labelProvider;
    private ServersHandlerListener serversHandlerListener;
    private ServerListener serverListener;
    private boolean stopAnimation;
    private List<Server> serversNeedingAnimation = new ArrayList<Server>();

    public ServersTableViewer(Tree tree) {
        super(tree);
        this.labelProvider = new ServersViewLabelProvider();
        this.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.setContentProvider((IContentProvider)new ServersViewContentProvider());
        this.setComparator(new ServersViewerComparator(this.labelProvider));
        this.setInput(ROOT);
        this.addListeners();
    }

    private void addListeners() {
        this.serversHandlerListener = new ServersHandlerListener(){

            public void serverAdded(Server server) {
                ServersTableViewer.this.addServer(server);
                server.addListener(ServersTableViewer.this.serverListener);
            }

            public void serverRemoved(Server server) {
                ServersTableViewer.this.refreshServer(server);
            }

            public void serverUpdated(Server server) {
                ServersTableViewer.this.removeServer(server);
                server.removeListener(ServersTableViewer.this.serverListener);
            }
        };
        ServersHandler.getDefault().addListener(this.serversHandlerListener);
        this.serverListener = new ServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serverChanged(ServerEvent event) {
                if (event == null) {
                    return;
                }
                ServerEventEnum kind = event.getKind();
                Server server = event.getServer();
                switch (kind) {
                    case STATE_CHANGED: {
                        ServersTableViewer.this.refreshServer(server);
                        ServerStateEnum state = server.getState();
                        if (state == ServerStateEnum.STARTING || state == ServerStateEnum.STOPPING) {
                            boolean startAnimationThread = false;
                            List list = ServersTableViewer.this.serversNeedingAnimation;
                            synchronized (list) {
                                if (!ServersTableViewer.this.serversNeedingAnimation.contains(server)) {
                                    if (ServersTableViewer.this.serversNeedingAnimation.isEmpty()) {
                                        startAnimationThread = true;
                                    }
                                    ServersTableViewer.this.serversNeedingAnimation.add(server);
                                }
                            }
                            if (!startAnimationThread) break;
                            ServersTableViewer.this.startAnimationThread();
                            break;
                        }
                        boolean stopAnimationThread = false;
                        List list = ServersTableViewer.this.serversNeedingAnimation;
                        synchronized (list) {
                            if (ServersTableViewer.this.serversNeedingAnimation.contains(server)) {
                                ServersTableViewer.this.serversNeedingAnimation.remove(server);
                                if (ServersTableViewer.this.serversNeedingAnimation.isEmpty()) {
                                    stopAnimationThread = true;
                                }
                            }
                        }
                        if (!stopAnimationThread) break;
                        ServersTableViewer.this.stopAnimationThread();
                        break;
                    }
                    case RENAMED: {
                        ServersTableViewer.this.refreshServer(server);
                    }
                }
            }
        };
        for (Server server : ServersHandler.getDefault().getServersList()) {
            server.addListener(this.serverListener);
        }
    }

    private void addServer(final Server server) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ServersTableViewer.this.add(ServersTableViewer.ROOT, server);
            }
        });
    }

    private void refreshServer(final Server server) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    ServersTableViewer.this.refresh(server);
                    ISelection sel = ServersTableViewer.this.getSelection();
                    ServersTableViewer.this.setSelection(sel);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void removeServer(final Server server) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ServersTableViewer.this.remove(server);
            }
        });
    }

    private void startAnimationThread() {
        Runnable[] animatorThread;
        this.stopAnimation = false;
        final Display display = this.getTree().getDisplay();
        int SLEEP = 200;
        animatorThread = new Runnable[]{new Runnable(){

            public void run() {
                if (!ServersTableViewer.this.stopAnimation) {
                    try {
                        ServersTableViewer.this.labelProvider.animate();
                        for (Server server : ServersTableViewer.this.serversNeedingAnimation.toArray(new Server[0])) {
                            if (server == null || ServersTableViewer.this.getTree() == null || ServersTableViewer.this.getTree().isDisposed()) continue;
                            ServersTableViewer.this.updateAnimation(server);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    display.timerExec(200, animatorThread[0]);
                }
            }
        }};
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                display.timerExec(200, animatorThread[0]);
            }
        });
    }

    private void stopAnimationThread() {
        this.stopAnimation = true;
    }

    private void updateAnimation(Server server) {
        try {
            Widget widget = this.doFindItem(server);
            TreeItem item = (TreeItem)widget;
            item.setText(1, this.labelProvider.getColumnText(server, 1));
            item.setImage(1, this.labelProvider.getColumnImage(server, 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void resortTable(final TreeColumn column, int col) {
        ServersViewerComparator sorter = (ServersViewerComparator)this.getComparator();
        if (col == sorter.getTopPriority()) {
            sorter.reverseTopPriority();
        } else {
            sorter.setTopPriority(col);
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ServersTableViewer.this.refresh();
                ServersTableViewer.this.updateDirectionIndicator(column);
            }
        });
    }

    protected void updateDirectionIndicator(TreeColumn column) {
        this.getTree().setSortColumn(column);
        if (((ServersViewerComparator)this.getComparator()).getTopPriorityDirection() == 1) {
            this.getTree().setSortDirection(128);
        } else {
            this.getTree().setSortDirection(1024);
        }
    }
}

