/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.jobs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.directory.studio.apacheds.ApacheDsPluginUtils;
import org.apache.directory.studio.apacheds.ConsolesHandler;
import org.apache.directory.studio.apacheds.LogMessageConsole;
import org.apache.directory.studio.apacheds.configuration.model.ServerConfiguration;
import org.apache.directory.studio.apacheds.configuration.model.v153.ServerConfigurationV153;
import org.apache.directory.studio.apacheds.configuration.model.v154.ServerConfigurationV154;
import org.apache.directory.studio.apacheds.configuration.model.v155.ServerConfigurationV155;
import org.apache.directory.studio.apacheds.jobs.Messages;
import org.apache.directory.studio.apacheds.model.Server;
import org.apache.directory.studio.apacheds.model.ServerStateEnum;
import org.apache.log4j.net.SocketServer;
import org.apache.mina.util.AvailablePortFinder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class LaunchServerJob
extends Job {
    private Server server;
    private ServerConfiguration configuration;
    private ILaunch launch;
    private static final int MIN_PORT = 1024;
    private String logsLevel = "WARN";
    private String logsPattern = "[%d{HH:mm:ss}] %p [%c] - %m%n";

    public LaunchServerJob(Server server, ServerConfiguration configuration) {
        super("");
        this.server = server;
        this.configuration = configuration;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.setName(NLS.bind((String)Messages.getString("LaunchServerJob.Starting"), (Object[])new String[]{this.server.getName()}));
        this.server.setState(ServerStateEnum.STARTING);
        this.writeToInfoConsoleMessageStream(Messages.getString("LaunchServerJob.ServerStarting"));
        int port = AvailablePortFinder.getNextAvailable((int)1024);
        this.launchSocketServer(port);
        try {
            this.overwriteServersLog4jPropertiesFile(port);
        }
        catch (IOException e) {
            ApacheDsPluginUtils.reportError(Messages.getString("LaunchServerJob.ErrorOverwritingLog") + e.getMessage());
        }
        this.launchApacheDS();
        this.startStartupListenerThread();
        this.startTerminateListenerThread();
        return Status.OK_STATUS;
    }

    private void startStartupListenerThread() {
        long startTime = System.currentTimeMillis();
        final long watchDog = startTime + 180000L;
        Thread thread = new Thread(){

            public void run() {
                while (System.currentTimeMillis() < watchDog && ServerStateEnum.STARTING == LaunchServerJob.this.server.getState()) {
                    try {
                        int port = this.getTestingPort(LaunchServerJob.this.configuration);
                        if (port != 0 && AvailablePortFinder.available((int)port)) {
                            throw new Exception();
                        }
                        LaunchServerJob.this.server.setState(ServerStateEnum.STARTED);
                        LaunchServerJob.this.writeToInfoConsoleMessageStream(Messages.getString("LaunchServerJob.ServerStarted"));
                        return;
                    }
                    catch (Exception e) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (ServerStateEnum.STARTING == LaunchServerJob.this.server.getState()) {
                    LaunchServerJob.this.server.setState(ServerStateEnum.STOPPED);
                    LaunchServerJob.this.writeToInfoConsoleMessageStream(Messages.getString("LaunchServerJob.ServerStopped"));
                }
            }

            private int getTestingPort(ServerConfiguration configuration) {
                if (configuration instanceof ServerConfigurationV155) {
                    return this.getTestingPortVersion155((ServerConfigurationV155)configuration);
                }
                if (configuration instanceof ServerConfigurationV154) {
                    return this.getTestingPortVersion154((ServerConfigurationV154)configuration);
                }
                if (configuration instanceof ServerConfigurationV153) {
                    return this.getTestingPortVersion153((ServerConfigurationV153)configuration);
                }
                return 0;
            }

            private int getTestingPortVersion153(ServerConfigurationV153 configuration) {
                if (configuration.isEnableLdap()) {
                    return configuration.getLdapPort();
                }
                if (configuration.isEnableLdaps()) {
                    return configuration.getLdapsPort();
                }
                if (configuration.isEnableKerberos()) {
                    return configuration.getKerberosPort();
                }
                if (configuration.isEnableDns()) {
                    return configuration.getDnsPort();
                }
                if (configuration.isEnableNtp()) {
                    return configuration.getNtpPort();
                }
                if (configuration.isEnableChangePassword()) {
                    return configuration.getChangePasswordPort();
                }
                return 0;
            }

            private int getTestingPortVersion154(ServerConfigurationV154 configuration) {
                if (configuration.isEnableLdap()) {
                    return configuration.getLdapPort();
                }
                if (configuration.isEnableLdaps()) {
                    return configuration.getLdapsPort();
                }
                if (configuration.isEnableKerberos()) {
                    return configuration.getKerberosPort();
                }
                if (configuration.isEnableDns()) {
                    return configuration.getDnsPort();
                }
                if (configuration.isEnableNtp()) {
                    return configuration.getNtpPort();
                }
                if (configuration.isEnableChangePassword()) {
                    return configuration.getChangePasswordPort();
                }
                return 0;
            }

            private int getTestingPortVersion155(ServerConfigurationV155 configuration) {
                if (configuration.isEnableLdap()) {
                    return configuration.getLdapPort();
                }
                if (configuration.isEnableLdaps()) {
                    return configuration.getLdapsPort();
                }
                if (configuration.isEnableKerberos()) {
                    return configuration.getKerberosPort();
                }
                if (configuration.isEnableDns()) {
                    return configuration.getDnsPort();
                }
                if (configuration.isEnableNtp()) {
                    return configuration.getNtpPort();
                }
                if (configuration.isEnableChangePassword()) {
                    return configuration.getChangePasswordPort();
                }
                return 0;
            }
        };
        thread.start();
    }

    private void writeToInfoConsoleMessageStream(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LogMessageConsole console = ConsolesHandler.getDefault().getLogMessageConsole(LaunchServerJob.this.server.getId());
                try {
                    console.getInfoConsoleMessageStream().write(message);
                }
                catch (IOException e) {
                    ApacheDsPluginUtils.reportError(Messages.getString("LaunchServerJob.ErrorWritingConsole") + e.getMessage());
                }
            }
        });
    }

    private void startTerminateListenerThread() {
        Thread thread = new Thread(){
            private IDebugEventSetListener debugEventSetListener;

            public void run() {
                this.debugEventSetListener = new IDebugEventSetListener(){

                    public void handleDebugEvents(DebugEvent[] events) {
                        for (DebugEvent debugEvent : events) {
                            RuntimeProcess runtimeProcess;
                            ILaunch debugEventLaunch;
                            Object source;
                            if (debugEvent.getKind() != 8 || !((source = debugEvent.getSource()) instanceof RuntimeProcess) || !(debugEventLaunch = (runtimeProcess = (RuntimeProcess)source).getLaunch()).equals(LaunchServerJob.this.launch)) continue;
                            LaunchServerJob.this.server.setState(ServerStateEnum.STOPPED);
                            DebugPlugin.getDefault().removeDebugEventListener(debugEventSetListener);
                        }
                    }
                };
                DebugPlugin.getDefault().addDebugEventListener(this.debugEventSetListener);
            }
        };
        thread.start();
    }

    private void launchSocketServer(int port) {
        final int finalPort = port;
        final IPath serverSocketFolderPath = ApacheDsPluginUtils.getApacheDsServersFolder().append(this.server.getId()).append("serverSocket");
        final IPath log4jPropertiesFilePath = serverSocketFolderPath.append("log4j.properties");
        Thread thread = new Thread(){

            public void run() {
                SocketServer.main((String[])new String[]{"" + finalPort, log4jPropertiesFilePath.toOSString(), serverSocketFolderPath.toOSString()});
            }
        };
        thread.start();
    }

    private void overwriteServersLog4jPropertiesFile(int port) throws IOException {
        IPath confFolderPath = ApacheDsPluginUtils.getApacheDsServersFolder().append(this.server.getId()).append("conf");
        File confFolder = new File(confFolderPath.toOSString());
        ApacheDsPluginUtils.createServersLog4jPropertiesFile(new FileOutputStream(new File(confFolder, "log4j.properties")), port, this.logsLevel, this.logsPattern);
    }

    private void launchApacheDS() {
        try {
            IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
            ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, NLS.bind((String)Messages.getString("LaunchServerJob.StartingServer"), (Object[])new String[]{this.server.getName()}));
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, vmInstall.getInstallLocation().toString());
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.apache.directory.studio.apacheds.Launcher");
            ArrayList<String> classpath = new ArrayList<String>();
            IPath apacheDsLibrariesFolder = ApacheDsPluginUtils.getApacheDsLibrariesFolder(this.server);
            for (String library : ApacheDsPluginUtils.getApacheDsLibraries(this.server)) {
                IRuntimeClasspathEntry libraryClasspathEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)apacheDsLibrariesFolder.append(library));
                libraryClasspathEntry.setClasspathProperty(3);
                classpath.add(libraryClasspathEntry.getMemento());
            }
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            IPath serverFolderPath = ApacheDsPluginUtils.getApacheDsServersFolder().append(this.server.getId());
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "\"" + serverFolderPath.toOSString() + "\"");
            StringBuffer vmArguments = new StringBuffer();
            vmArguments.append("-Dlog4j.configuration=file:\"" + serverFolderPath.append("conf").append("log4j.properties").toOSString() + "\"");
            vmArguments.append(" ");
            vmArguments.append("-Dapacheds.var.dir=\"" + serverFolderPath.toOSString() + "\"");
            vmArguments.append(" ");
            vmArguments.append("-Dapacheds.log.dir=\"" + serverFolderPath.append("log").toOSString() + "\"");
            vmArguments.append(" ");
            vmArguments.append("-Dapacheds.run.dir=\"" + serverFolderPath.append("run").toOSString() + "\"");
            vmArguments.append(" ");
            vmArguments.append("-Dapacheds.instance=\"" + this.server.getName() + "\"");
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArguments.toString());
            workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
            workingCopy.setAttribute("org.eclipse.debug.core.capture_output", false);
            ILaunchConfiguration configuration = workingCopy.doSave();
            this.launch = configuration.launch("run", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ApacheDsPluginUtils.reportError(Messages.getString("LaunchServerJob.ErrorLaunching") + e.getMessage());
        }
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public void setLogsLevel(String logsLevel) {
        this.logsLevel = logsLevel;
    }

    public void setLogsPattern(String logsPattern) {
        this.logsPattern = logsPattern;
    }
}

