/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.actions;

import java.io.IOException;
import org.apache.directory.studio.apacheds.ApacheDsPlugin;
import org.apache.directory.studio.apacheds.ApacheDsPluginConstants;
import org.apache.directory.studio.apacheds.ApacheDsPluginUtils;
import org.apache.directory.studio.apacheds.ConsolesHandler;
import org.apache.directory.studio.apacheds.LogMessageConsole;
import org.apache.directory.studio.apacheds.actions.Messages;
import org.apache.directory.studio.apacheds.jobs.LaunchServerJob;
import org.apache.directory.studio.apacheds.model.Server;
import org.apache.directory.studio.apacheds.model.ServerStateEnum;
import org.apache.directory.studio.apacheds.views.ServersView;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class StopAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private ServersView view;
    private Server server;

    public StopAction() {
        super(Messages.getString("StopAction.Stop"));
        this.init();
    }

    public StopAction(ServersView view) {
        super(Messages.getString("StopAction.Stop"));
        this.view = view;
        this.init();
    }

    private void init() {
        this.setId(ApacheDsPluginConstants.CMD_STOP);
        this.setActionDefinitionId(ApacheDsPluginConstants.CMD_STOP);
        this.setToolTipText(Messages.getString("StopAction.StopToolTip"));
        this.setImageDescriptor(ApacheDsPlugin.getDefault().getImageDescriptor("resources/icons/stop.gif"));
    }

    public void run() {
        StructuredSelection selection;
        if (this.view != null && !(selection = (StructuredSelection)this.view.getViewer().getSelection()).isEmpty() && selection.size() == 1) {
            ILaunch launch;
            this.server = (Server)selection.getFirstElement();
            this.server.setState(ServerStateEnum.STOPPING);
            LaunchServerJob launchJob = this.server.getLaunchJob();
            if (launchJob != null && (launch = launchJob.getLaunch()) != null && !launch.isTerminated()) {
                try {
                    launch.terminate();
                    this.writeToInfoConsoleMessageStream(Messages.getString("StopAction.ServerStopped"));
                }
                catch (DebugException e) {
                    ApacheDsPluginUtils.reportError(Messages.getString("StopAction.ErrorWhenStopping") + e.getMessage());
                }
            }
        }
    }

    private void writeToInfoConsoleMessageStream(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LogMessageConsole console = ConsolesHandler.getDefault().getLogMessageConsole(StopAction.this.server.getId());
                try {
                    console.getInfoConsoleMessageStream().write(message);
                }
                catch (IOException e) {
                    ApacheDsPluginUtils.reportError(Messages.getString("StopAction.ErrorWhenWriting") + e.getMessage());
                }
            }
        });
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

