/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.actions;

import org.apache.directory.studio.apacheds.ApacheDsPluginConstants;
import org.apache.directory.studio.apacheds.ApacheDsPluginUtils;
import org.apache.directory.studio.apacheds.actions.Messages;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.model.Server;
import org.apache.directory.studio.apacheds.views.ServersView;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenConfigurationAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private ServersView view;

    public OpenConfigurationAction() {
        super(Messages.getString("OpenConfigurationAction.OpenConfiguration"));
        this.init();
    }

    public OpenConfigurationAction(ServersView view) {
        super(Messages.getString("OpenConfigurationAction.OpenConfiguration"));
        this.view = view;
        this.init();
    }

    private void init() {
        this.setId(ApacheDsPluginConstants.CMD_OPEN_CONFIGURATION);
        this.setActionDefinitionId(ApacheDsPluginConstants.CMD_OPEN_CONFIGURATION);
        this.setToolTipText(Messages.getString("OpenConfigurationAction.OpenConfigurationToolTip"));
    }

    public void run() {
        StructuredSelection selection;
        Server server;
        if (this.view != null && (server = (Server)(selection = (StructuredSelection)this.view.getViewer().getSelection()).getFirstElement()) != null) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            PathEditorInput input = new PathEditorInput(ApacheDsPluginUtils.getApacheDsServersFolder().append(server.getId()).append("conf").append("server.xml"));
            try {
                page.openEditor((IEditorInput)input, ServerConfigurationEditor.ID);
            }
            catch (PartInitException e) {
                ApacheDsPluginUtils.reportError(Messages.getString("OpenConfigurationAction.ErrorWhenOpening") + e.getMessage());
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    class PathEditorInput
    implements IPathEditorInput {
        private IPath path;

        public PathEditorInput(IPath path) {
            if (path == null) {
                throw new IllegalArgumentException();
            }
            this.path = path;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof PathEditorInput) {
                PathEditorInput input = (PathEditorInput)o;
                return this.path.equals(input.path);
            }
            return false;
        }

        public boolean exists() {
            return this.path.toFile().exists();
        }

        public ImageDescriptor getImageDescriptor() {
            return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.path.toString());
        }

        public String getName() {
            return this.path.toFile().getName();
        }

        public String getToolTipText() {
            return this.path.makeRelative().toOSString();
        }

        public IPath getPath() {
            return this.path;
        }

        public Object getAdapter(Class adapter) {
            return Platform.getAdapterManager().getAdapter((Object)this, adapter);
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public IPath getErrorMessage(Object element) {
            if (element instanceof PathEditorInput) {
                PathEditorInput input = (PathEditorInput)element;
                return input.getPath();
            }
            return null;
        }
    }
}

