/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.views;

import org.apache.directory.studio.apacheds.ApacheDsPlugin;
import org.apache.directory.studio.apacheds.model.Server;
import org.apache.directory.studio.apacheds.model.ServerStateEnum;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ServersViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String THREE_DOTS = "...";
    private static final String TWO_DOTS = "..";
    private static final String ONE_DOT = ".";
    private int count = 1;

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof Server) {
            Server server = (Server)element;
            if (columnIndex == 0) {
                return server.getName();
            }
            if (columnIndex == 1) {
                ServerStateEnum state = ((Server)element).getState();
                switch (state) {
                    case STARTED: {
                        return state.toString();
                    }
                    case STARTING: {
                        return state.toString() + this.getDots();
                    }
                    case STOPPED: {
                        return state.toString();
                    }
                    case STOPPING: {
                        return state.toString() + this.getDots();
                    }
                    case UNKNONW: {
                        return state.toString();
                    }
                }
            }
        }
        return null;
    }

    private String getDots() {
        if (this.count == 1) {
            return ONE_DOT;
        }
        if (this.count == 2) {
            return TWO_DOTS;
        }
        return THREE_DOTS;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof Server) {
            if (columnIndex == 0) {
                return ApacheDsPlugin.getDefault().getImage("resources/icons/server.gif");
            }
            if (columnIndex == 1) {
                switch (((Server)element).getState()) {
                    case STARTED: {
                        return ApacheDsPlugin.getDefault().getImage("resources/icons/server_started.gif");
                    }
                    case STARTING: {
                        switch (this.count) {
                            case 1: {
                                return ApacheDsPlugin.getDefault().getImage("resources/icons/server_starting1.gif");
                            }
                            case 2: {
                                return ApacheDsPlugin.getDefault().getImage("resources/icons/server_starting2.gif");
                            }
                            case 3: {
                                return ApacheDsPlugin.getDefault().getImage("resources/icons/server_starting3.gif");
                            }
                        }
                    }
                    case STOPPED: {
                        return ApacheDsPlugin.getDefault().getImage("resources/icons/server_stopped.gif");
                    }
                    case STOPPING: {
                        switch (this.count) {
                            case 1: {
                                return ApacheDsPlugin.getDefault().getImage("resources/icons/server_stopping1.gif");
                            }
                            case 2: {
                                return ApacheDsPlugin.getDefault().getImage("resources/icons/server_stopping2.gif");
                            }
                            case 3: {
                                return ApacheDsPlugin.getDefault().getImage("resources/icons/server_stopping3.gif");
                            }
                        }
                    }
                    case UNKNONW: {
                        return ApacheDsPlugin.getDefault().getImage("resources/icons/server.gif");
                    }
                }
            }
        }
        return null;
    }

    public void animate() {
        ++this.count;
        if (this.count > 3) {
            this.count = 1;
        }
    }
}

