/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.model;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.directory.studio.apacheds.jobs.LaunchServerJob;
import org.apache.directory.studio.apacheds.model.Messages;
import org.apache.directory.studio.apacheds.model.ServerEvent;
import org.apache.directory.studio.apacheds.model.ServerEventEnum;
import org.apache.directory.studio.apacheds.model.ServerListener;
import org.apache.directory.studio.apacheds.model.ServerStateEnum;
import org.apache.directory.studio.apacheds.model.ServerVersion;
import org.eclipse.core.runtime.IAdaptable;

public class Server
implements IAdaptable {
    private String name;
    private String id;
    private ServerVersion version = ServerVersion.VERSION_1_5_5;
    private ServerStateEnum state = ServerStateEnum.STOPPED;
    private List<ServerListener> listeners = new ArrayList<ServerListener>();
    private LaunchServerJob launchJob;

    public Server() {
    }

    public void addListener(ServerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(Messages.getString("Server.ListenerCantBeNull"));
        }
        this.listeners.add(listener);
    }

    public void removeListener(ServerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(Messages.getString("Server.ListenerCantBeNull"));
        }
        this.listeners.remove(listener);
    }

    public Server(String name) {
        this.name = name;
        this.id = Server.createId();
    }

    public Server(String name, String id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name == name) {
            return;
        }
        this.name = name;
        this.fireServerNameChangeEvent();
    }

    private void fireServerNameChangeEvent() {
        for (ServerListener listener : this.listeners.toArray(new ServerListener[0])) {
            listener.serverChanged(new ServerEvent(this, ServerEventEnum.RENAMED));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static String createId() {
        return UUID.randomUUID().toString();
    }

    public ServerStateEnum getState() {
        return this.state;
    }

    public void setState(ServerStateEnum state) {
        if (this.state == state) {
            return;
        }
        this.state = state;
        this.fireServerStateChangeEvent();
    }

    private void fireServerStateChangeEvent() {
        for (ServerListener listener : this.listeners.toArray(new ServerListener[0])) {
            listener.serverChanged(new ServerEvent(this, ServerEventEnum.STATE_CHANGED));
        }
    }

    public LaunchServerJob getLaunchJob() {
        return this.launchJob;
    }

    public void setLaunchJob(LaunchServerJob launchJob) {
        this.launchJob = launchJob;
    }

    public ServerVersion getVersion() {
        return this.version;
    }

    public void setVersion(ServerVersion version) {
        this.version = version;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

