/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.actions;

import org.apache.directory.studio.apacheds.ApacheDsPluginConstants;
import org.apache.directory.studio.apacheds.actions.Messages;
import org.apache.directory.studio.apacheds.model.Server;
import org.apache.directory.studio.apacheds.model.ServersHandler;
import org.apache.directory.studio.apacheds.views.ServersView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.TextActionHandler;

public class RenameAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private ServersView view;
    private Tree tree;
    private TreeEditor treeEditor;
    protected Composite textEditorParent;
    protected Text textEditor;
    private TextActionHandler textActionHandler;
    protected Server editedServer;
    protected boolean saving = false;

    public RenameAction() {
        super(Messages.getString("RenameAction.Rename"));
        this.init();
    }

    public RenameAction(ServersView view) {
        super(Messages.getString("RenameAction.Rename"));
        this.view = view;
        this.tree = view.getViewer().getTree();
        this.treeEditor = new TreeEditor(this.tree);
        this.init();
    }

    private void init() {
        this.setId(ApacheDsPluginConstants.CMD_RENAME);
        this.setActionDefinitionId(ApacheDsPluginConstants.CMD_RENAME);
        this.setToolTipText(Messages.getString("RenameAction.RenameToolTip"));
    }

    public void run() {
        StructuredSelection selection;
        Server server;
        if (this.view != null && (server = (Server)(selection = (StructuredSelection)this.view.getViewer().getSelection()).getFirstElement()) != null) {
            this.queryNewServerNameInline(server);
        }
    }

    private void queryNewServerNameInline(Server server) {
        if (this.textEditorParent == null) {
            this.createTextEditor(server);
        }
        this.textEditor.setText(server.getName());
        this.textEditorParent.setVisible(true);
        Point textSize = this.textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.textEditorParent.getSize();
        int inset = RenameAction.getCellEditorInset((Control)this.textEditorParent);
        this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
        this.textEditorParent.redraw();
        this.textEditor.selectAll();
        this.textEditor.setFocus();
    }

    private void createTextEditor(final Server server) {
        this.textEditorParent = this.createParent();
        this.textEditorParent.setVisible(false);
        final int inset = RenameAction.getCellEditorInset((Control)this.textEditorParent);
        if (inset > 0) {
            this.textEditorParent.addListener(9, new Listener(){

                public void handleEvent(Event e) {
                    Point textSize = RenameAction.this.textEditor.getSize();
                    Point parentSize = RenameAction.this.textEditorParent.getSize();
                    e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
                }
            });
        }
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditor.setFont(this.tree.getFont());
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = RenameAction.this.textEditor.computeSize(-1, -1);
                textSize.x += textSize.y;
                Point parentSize = RenameAction.this.textEditorParent.getSize();
                RenameAction.this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
                RenameAction.this.textEditorParent.redraw();
            }
        });
        this.textEditor.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        RenameAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        RenameAction.this.saveChangesAndDispose(server);
                        event.doit = true;
                        event.detail = 0;
                    }
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                RenameAction.this.saveChangesAndDispose(server);
            }
        });
        if (this.textActionHandler != null) {
            this.textActionHandler.addText(this.textEditor);
        }
    }

    private Composite createParent() {
        Tree tree2 = this.tree;
        Composite result = new Composite((Composite)tree2, 0);
        TreeItem[] selectedItems = tree2.getSelection();
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.setEditor((Control)result, selectedItems[0]);
        return result;
    }

    protected void disposeTextWidget() {
        if (this.textActionHandler != null) {
            this.textActionHandler.removeText(this.textEditor);
        }
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            this.treeEditor.setEditor(null, null);
        }
    }

    protected void saveChangesAndDispose(Server server) {
        if (this.saving) {
            return;
        }
        this.saving = true;
        this.editedServer = server;
        final String newName = this.textEditor.getText();
        this.tree.getShell().getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (!newName.equals(RenameAction.this.editedServer.getName())) {
                        if (!ServersHandler.getDefault().isNameAvailable(newName)) {
                            MessageDialog.openError((Shell)RenameAction.this.tree.getShell(), (String)Messages.getString("RenameAction.Server"), (String)Messages.getString("RenameAction.ErrorNameInUse"));
                        } else {
                            RenameAction.this.editedServer.setName(newName);
                        }
                    }
                    RenameAction.this.editedServer = null;
                    RenameAction.this.disposeTextWidget();
                    if (RenameAction.this.tree != null && !RenameAction.this.tree.isDisposed()) {
                        RenameAction.this.tree.setFocus();
                    }
                }
                finally {
                    RenameAction.this.saving = false;
                }
            }
        });
    }

    private static int getCellEditorInset(Control c) {
        if ("carbon".equals(SWT.getPlatform()) && (System.getProperty("org.eclipse.swt.internal.carbon.noFocusRing") == null || c.getShell().getParent() != null)) {
            return -2;
        }
        return 1;
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

