/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds;

import org.apache.directory.studio.apacheds.ApacheDsPlugin;
import org.apache.directory.studio.apacheds.PreferenceStoreUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class LogMessageConsole
extends MessageConsole {
    private IPreferenceStore preferenceStore = ApacheDsPlugin.getDefault().getPreferenceStore();
    private MessageConsoleStream debugMessageConsoleStream;
    private MessageConsoleStream infoMessageConsoleStream;
    private MessageConsoleStream warnMessageConsoleStream;
    private MessageConsoleStream errorMessageConsoleStream;
    private MessageConsoleStream fatalMessageConsoleStream;

    public LogMessageConsole(String name, ImageDescriptor imageDescriptor) {
        super(name, imageDescriptor);
    }

    public LogMessageConsole(String name) {
        super(name, null);
    }

    public MessageConsoleStream getDebugConsoleMessageStream() {
        if (this.debugMessageConsoleStream == null) {
            this.createDebugMessageConsoleStream();
        }
        return this.debugMessageConsoleStream;
    }

    private void createDebugMessageConsoleStream() {
        this.debugMessageConsoleStream = this.newMessageStream();
        this.setColorAndFontSettingsToMessageConsoleStream(this.debugMessageConsoleStream, "prefs.colorAndFonts.debugColor", "prefs.colorAndFonts.debugFont");
    }

    public MessageConsoleStream getInfoConsoleMessageStream() {
        if (this.infoMessageConsoleStream == null) {
            this.createInfoMessageConsoleStream();
        }
        return this.infoMessageConsoleStream;
    }

    private void createInfoMessageConsoleStream() {
        this.infoMessageConsoleStream = this.newMessageStream();
        this.setColorAndFontSettingsToMessageConsoleStream(this.infoMessageConsoleStream, "prefs.colorAndFonts.infoColor", "prefs.colorAndFonts.infoFont");
    }

    public MessageConsoleStream getWarnConsoleMessageStream() {
        if (this.warnMessageConsoleStream == null) {
            this.createWarnMessageConsoleStream();
        }
        return this.warnMessageConsoleStream;
    }

    private void createWarnMessageConsoleStream() {
        this.warnMessageConsoleStream = this.newMessageStream();
        this.setColorAndFontSettingsToMessageConsoleStream(this.warnMessageConsoleStream, "prefs.colorAndFonts.warnColor", "prefs.colorAndFonts.warnFont");
    }

    public MessageConsoleStream getErrorConsoleMessageStream() {
        if (this.errorMessageConsoleStream == null) {
            this.createErrorMessageConsoleStream();
        }
        return this.errorMessageConsoleStream;
    }

    private void createErrorMessageConsoleStream() {
        this.errorMessageConsoleStream = this.newMessageStream();
        this.setColorAndFontSettingsToMessageConsoleStream(this.errorMessageConsoleStream, "prefs.colorAndFonts.errorColor", "prefs.colorAndFonts.errorFont");
    }

    public MessageConsoleStream getFatalConsoleMessageStream() {
        if (this.fatalMessageConsoleStream == null) {
            this.createFatalMessageConsoleStream();
        }
        return this.fatalMessageConsoleStream;
    }

    private void createFatalMessageConsoleStream() {
        this.fatalMessageConsoleStream = this.newMessageStream();
        this.setColorAndFontSettingsToMessageConsoleStream(this.fatalMessageConsoleStream, "prefs.colorAndFonts.fatalColor", "prefs.colorAndFonts.fatalFont");
    }

    private void setColorAndFontSettingsToMessageConsoleStream(MessageConsoleStream messageConsoleStream, String colorPreferenceName, String fontPreferenceName) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)colorPreferenceName);
        FontData[] fontDatas = PreferenceConverter.getFontDataArray((IPreferenceStore)this.preferenceStore, (String)fontPreferenceName);
        int style = 0;
        if (PreferenceStoreUtils.isBold(fontDatas)) {
            style |= 1;
        }
        if (PreferenceStoreUtils.isItalic(fontDatas)) {
            style |= 2;
        }
        messageConsoleStream.setColor(new Color((Device)ApacheDsPlugin.getDefault().getWorkbench().getDisplay(), rgb));
        messageConsoleStream.setFontStyle(style);
    }
}

