/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.wizards;

import org.apache.directory.studio.apacheds.ApacheDsPlugin;
import org.apache.directory.studio.apacheds.model.ServersHandler;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewServerWizardPage
extends WizardPage {
    private ServersHandler serversHandler;
    private Text nameText;

    public NewServerWizardPage() {
        super(NewServerWizardPage.class.getCanonicalName());
        this.setTitle("Create a Server");
        this.setDescription("Please specify a name to create a new server.");
        this.setImageDescriptor(ApacheDsPlugin.getDefault().getImageDescriptor("resources/icons/server_new_wizard.png"));
        this.setPageComplete(false);
        this.serversHandler = ServersHandler.getDefault();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Name:");
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewServerWizardPage.this.validate();
            }
        });
        this.setControl((Control)composite);
    }

    private void validate() {
        this.displayErrorMessage(null);
        String name = this.nameText.getText();
        if (name != null) {
            if ("".equals(name)) {
                this.displayErrorMessage("Enter a name for the server.");
                return;
            }
            if (!this.serversHandler.isNameAvailable(name)) {
                this.displayErrorMessage("A server with the same name already exists.");
                return;
            }
        }
    }

    protected void displayErrorMessage(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getServerName() {
        return this.nameText.getText();
    }
}

