/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.views;

import org.apache.directory.studio.apacheds.ApacheDsPluginConstants;
import org.apache.directory.studio.apacheds.actions.CreateConnectionAction;
import org.apache.directory.studio.apacheds.actions.DeleteAction;
import org.apache.directory.studio.apacheds.actions.NewServerAction;
import org.apache.directory.studio.apacheds.actions.OpenConfigurationAction;
import org.apache.directory.studio.apacheds.actions.PropertiesAction;
import org.apache.directory.studio.apacheds.actions.RenameAction;
import org.apache.directory.studio.apacheds.actions.RunAction;
import org.apache.directory.studio.apacheds.actions.StopAction;
import org.apache.directory.studio.apacheds.model.Server;
import org.apache.directory.studio.apacheds.model.ServersHandler;
import org.apache.directory.studio.apacheds.model.ServersHandlerListener;
import org.apache.directory.studio.apacheds.views.ServersTableViewer;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;

public class ServersView
extends ViewPart {
    public static final String ID = ApacheDsPluginConstants.VIEW_SERVERS_VIEW;
    private Tree tree;
    private ServersTableViewer tableViewer;
    private ServersView instance;
    private IContextActivation contextActivation;
    private static final String TAG_COLUMN_WIDTH = "columnWidth";
    protected int[] columnWidths;
    private NewServerAction newServer;
    private OpenConfigurationAction openConfiguration;
    private DeleteAction delete;
    private RenameAction rename;
    private RunAction run;
    private StopAction stop;
    private CreateConnectionAction createConnection;
    private PropertiesAction properties;
    private ServersHandlerListener serversHandlerListener = new ServersHandlerListener(){

        public void serverAdded(Server server) {
            ServersView.this.tableViewer.refresh();
        }

        public void serverRemoved(Server server) {
            ServersView.this.tableViewer.refresh();
        }

        public void serverUpdated(Server server) {
            ServersView.this.tableViewer.refresh();
        }
    };

    public void createPartControl(Composite parent) {
        this.instance = this;
        this.tree = new Tree(parent, 66308);
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(false);
        TreeColumn serverColumn = new TreeColumn(this.tree, 4);
        serverColumn.setText("Server");
        serverColumn.setWidth(this.columnWidths[0]);
        serverColumn.addSelectionListener(this.getHeaderListener(0));
        this.tree.setSortColumn(serverColumn);
        this.tree.setSortDirection(128);
        TreeColumn stateColumn = new TreeColumn(this.tree, 4);
        stateColumn.setText("State");
        stateColumn.setWidth(this.columnWidths[1]);
        stateColumn.addSelectionListener(this.getHeaderListener(1));
        this.tableViewer = new ServersTableViewer(this.tree);
        this.initActions();
        this.initToolbar();
        this.initContextMenu();
        this.initListeners();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, ApacheDsPluginConstants.PLUGIN_ID + "." + "gettingstarted_views_servers");
    }

    private SelectionListener getHeaderListener(final int col) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServersView.this.tableViewer == null) {
                    return;
                }
                TreeColumn column = (TreeColumn)e.widget;
                ServersView.this.tableViewer.resortTable(column, col);
            }
        };
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.columnWidths = new int[]{150, 80};
        for (int i = 0; i < 2; ++i) {
            Integer in;
            if (memento == null || (in = memento.getInteger(TAG_COLUMN_WIDTH + i)) == null || in <= 5) continue;
            this.columnWidths[i] = in;
        }
    }

    public void saveState(IMemento memento) {
        TreeColumn[] tc = this.tableViewer.getTree().getColumns();
        for (int i = 0; i < 2; ++i) {
            int width = tc[i].getWidth();
            if (width == 0) continue;
            memento.putInteger(TAG_COLUMN_WIDTH + i, width);
        }
    }

    public void setFocus() {
        if (this.tree != null) {
            this.tree.setFocus();
        }
    }

    private void initActions() {
        this.newServer = new NewServerAction();
        this.openConfiguration = new OpenConfigurationAction(this);
        this.openConfiguration.setEnabled(false);
        this.delete = new DeleteAction(this);
        this.delete.setEnabled(false);
        this.rename = new RenameAction(this);
        this.rename.setEnabled(false);
        this.run = new RunAction(this);
        this.run.setEnabled(false);
        this.stop = new StopAction(this);
        this.stop.setEnabled(false);
        this.createConnection = new CreateConnectionAction(this);
        this.createConnection.setEnabled(false);
        this.properties = new PropertiesAction(this);
        this.properties.setEnabled(false);
    }

    private void initToolbar() {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        toolbar.add((IAction)this.newServer);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)this.run);
        toolbar.add((IAction)this.stop);
    }

    private void initContextMenu() {
        MenuManager contextMenu = new MenuManager("");
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MenuManager newManager = new MenuManager("&New");
                newManager.add((IAction)ServersView.this.newServer);
                manager.add((IContributionItem)newManager);
                manager.add((IAction)ServersView.this.openConfiguration);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)ServersView.this.delete);
                manager.add((IAction)ServersView.this.rename);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)ServersView.this.run);
                manager.add((IAction)ServersView.this.stop);
                manager.add((IContributionItem)new Separator());
                MenuManager ldapBrowserManager = new MenuManager("LDAP Browser");
                ldapBrowserManager.add((IAction)ServersView.this.createConnection);
                manager.add((IContributionItem)ldapBrowserManager);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)ServersView.this.properties);
            }
        });
        this.tableViewer.getControl().setMenu(contextMenu.createContextMenu(this.tableViewer.getControl()));
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.tableViewer);
    }

    private void initListeners() {
        ServersHandler serversHandler = ServersHandler.getDefault();
        serversHandler.addListener(this.serversHandlerListener);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ServersView.this.openConfiguration.run();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ServersView.this.updateActionsStates();
            }
        });
        this.getSite().getPage().addPartListener(new IPartListener2(){

            public void partDeactivated(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == ServersView.this.instance && ServersView.this.contextActivation != null) {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
                    if (commandService != null) {
                        commandService.getCommand(ServersView.this.newServer.getActionDefinitionId()).setHandler(null);
                        commandService.getCommand(ServersView.this.openConfiguration.getActionDefinitionId()).setHandler(null);
                        commandService.getCommand(ServersView.this.delete.getActionDefinitionId()).setHandler(null);
                        commandService.getCommand(ServersView.this.rename.getActionDefinitionId()).setHandler(null);
                        commandService.getCommand(ServersView.this.run.getActionDefinitionId()).setHandler(null);
                        commandService.getCommand(ServersView.this.stop.getActionDefinitionId()).setHandler(null);
                        commandService.getCommand(ServersView.this.properties.getActionDefinitionId()).setHandler(null);
                    }
                    IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
                    contextService.deactivateContext(ServersView.this.contextActivation);
                    ServersView.this.contextActivation = null;
                }
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == ServersView.this.instance) {
                    IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
                    ServersView.this.contextActivation = contextService.activateContext(ApacheDsPluginConstants.CONTEXTS_SERVERS_VIEW);
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
                    if (commandService != null) {
                        commandService.getCommand(ServersView.this.newServer.getActionDefinitionId()).setHandler((IHandler)new ActionHandler((IAction)ServersView.this.newServer));
                        commandService.getCommand(ServersView.this.openConfiguration.getActionDefinitionId()).setHandler((IHandler)new ActionHandler((IAction)ServersView.this.openConfiguration));
                        commandService.getCommand(ServersView.this.delete.getActionDefinitionId()).setHandler((IHandler)new ActionHandler((IAction)ServersView.this.delete));
                        commandService.getCommand(ServersView.this.rename.getActionDefinitionId()).setHandler((IHandler)new ActionHandler((IAction)ServersView.this.rename));
                        commandService.getCommand(ServersView.this.run.getActionDefinitionId()).setHandler((IHandler)new ActionHandler((IAction)ServersView.this.run));
                        commandService.getCommand(ServersView.this.stop.getActionDefinitionId()).setHandler((IHandler)new ActionHandler((IAction)ServersView.this.stop));
                        commandService.getCommand(ServersView.this.properties.getActionDefinitionId()).setHandler((IHandler)new ActionHandler((IAction)ServersView.this.properties));
                    }
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }
        });
    }

    public void updateActionsStates() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        if (!selection.isEmpty()) {
            Server server = (Server)selection.getFirstElement();
            switch (server.getState()) {
                case STARTED: {
                    this.run.setEnabled(false);
                    this.stop.setEnabled(true);
                    break;
                }
                case STARTING: {
                    this.run.setEnabled(false);
                    this.stop.setEnabled(false);
                    break;
                }
                case STOPPED: {
                    this.run.setEnabled(true);
                    this.stop.setEnabled(false);
                    break;
                }
                case STOPPING: {
                    this.run.setEnabled(false);
                    this.stop.setEnabled(false);
                    break;
                }
                case UNKNONW: {
                    this.run.setEnabled(false);
                    this.stop.setEnabled(false);
                }
            }
            this.openConfiguration.setEnabled(true);
            this.delete.setEnabled(true);
            this.rename.setEnabled(true);
            this.createConnection.setEnabled(true);
            this.properties.setEnabled(true);
        } else {
            this.openConfiguration.setEnabled(false);
            this.delete.setEnabled(false);
            this.rename.setEnabled(false);
            this.run.setEnabled(false);
            this.stop.setEnabled(false);
            this.createConnection.setEnabled(false);
            this.properties.setEnabled(false);
        }
    }

    public TreeViewer getViewer() {
        return this.tableViewer;
    }

    public void dispose() {
        ServersHandler serversHandler = ServersHandler.getDefault();
        serversHandler.removeListener(this.serversHandlerListener);
        super.dispose();
    }
}

