/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.prefs;

import org.apache.directory.studio.apacheds.ApacheDsPlugin;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ServerLogsPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo levelCombo;
    private Text patternText;
    private Label previewLabel;
    private Group conversionPatternGroup;

    public ServerLogsPage() {
        super("Server Logs");
        this.setPreferenceStore(ApacheDsPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Link colorsAndFontsLink = new Link(composite, 0);
        GridData gd = new GridData(4, 1, true, false);
        gd.widthHint = 150;
        colorsAndFontsLink.setLayoutData((Object)gd);
        colorsAndFontsLink.setText("Default colors and fonts settings can be configured on the <a>Colors and Fonts</a> preference page.");
        colorsAndFontsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)ServerLogsPage.this.getShell(), (String)ApacheDsPlugin.getDefault().getPluginProperties().getString("Pref_ColorsAndFontsPage_id"), null, null);
            }
        });
        Group logLevelGroup = new Group(composite, 0);
        logLevelGroup.setText("Log Level");
        logLevelGroup.setLayout((Layout)new GridLayout(2, false));
        logLevelGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Label levelLabel = new Label((Composite)logLevelGroup, 0);
        levelLabel.setText("Level:");
        this.levelCombo = new Combo((Composite)logLevelGroup, 76);
        this.levelCombo.add("Debug", 0);
        this.levelCombo.add("Info", 1);
        this.levelCombo.add("Warning", 2);
        this.levelCombo.add("Error", 3);
        this.levelCombo.add("Fatal", 4);
        new Label((Composite)logLevelGroup, 0);
        Label warningLabel = new Label((Composite)logLevelGroup, 64);
        warningLabel.setText("Warning: Setting the log level to 'Debug' or 'Info' can cause issues and slow down the server.");
        warningLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.conversionPatternGroup = new Group(composite, 0);
        this.conversionPatternGroup.setText("Conversion Pattern");
        this.conversionPatternGroup.setLayout((Layout)new GridLayout(2, false));
        this.conversionPatternGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Label patternLabel = new Label((Composite)this.conversionPatternGroup, 0);
        patternLabel.setText("Pattern:");
        this.patternText = new Text((Composite)this.conversionPatternGroup, 2048);
        this.patternText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.patternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerLogsPage.this.updatePreviewLabel();
            }
        });
        Label label = new Label((Composite)this.conversionPatternGroup, 0);
        label.setText("Preview:");
        this.previewLabel = new Label((Composite)this.conversionPatternGroup, 0);
        this.previewLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.initFromPreferences();
        this.applyDialogFont(composite);
        return composite;
    }

    private void updatePreviewLabel() {
        LoggingEvent loggingEvent = new LoggingEvent("CategoryClass", (Category)Logger.getLogger((String)"logger"), (Priority)Level.INFO, (Object)"Logging message", (Throwable)new Exception("AnException"));
        this.previewLabel.setText(new PatternLayout(this.patternText.getText()).format(loggingEvent));
    }

    private void initFromPreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        String level = store.getString("prefs.serverLogs.level");
        if ("debug".equalsIgnoreCase(level)) {
            this.levelCombo.select(0);
        } else if ("info".equalsIgnoreCase(level)) {
            this.levelCombo.select(1);
        } else if ("warning".equalsIgnoreCase(level)) {
            this.levelCombo.select(2);
        } else if ("error".equalsIgnoreCase(level)) {
            this.levelCombo.select(3);
        } else if ("fatal".equalsIgnoreCase(level)) {
            this.levelCombo.select(4);
        }
        this.patternText.setText(store.getString("prefs.serverLogs.pattern"));
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        String level = store.getDefaultString("prefs.serverLogs.level");
        if ("debug".equalsIgnoreCase(level)) {
            this.levelCombo.select(0);
        } else if ("info".equalsIgnoreCase(level)) {
            this.levelCombo.select(1);
        } else if ("warning".equalsIgnoreCase(level)) {
            this.levelCombo.select(2);
        } else if ("error".equalsIgnoreCase(level)) {
            this.levelCombo.select(3);
        } else if ("fatal".equalsIgnoreCase(level)) {
            this.levelCombo.select(4);
        }
        this.patternText.setText(store.getDefaultString("prefs.serverLogs.pattern"));
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        int level = this.levelCombo.getSelectionIndex();
        store.getDefaultString("prefs.serverLogs.level");
        if (level == 0) {
            store.setValue("prefs.serverLogs.level", "debug");
        } else if (level == 1) {
            store.setValue("prefs.serverLogs.level", "info");
        } else if (level == 2) {
            store.setValue("prefs.serverLogs.level", "warning");
        } else if (level == 3) {
            store.setValue("prefs.serverLogs.level", "error");
        } else if (level == 4) {
            store.setValue("prefs.serverLogs.level", "fatal");
        }
        store.setValue("prefs.serverLogs.pattern", this.patternText.getText());
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }
}

