/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.prefs;

import org.apache.directory.studio.apacheds.ApacheDsPlugin;
import org.apache.directory.studio.apacheds.PreferenceStoreUtils;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ColorsAndFontsPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ColorSelector debugColorButton;
    private Button debugBoldCheckbox;
    private Button debugItalicCheckbox;
    private ColorSelector infoColorButton;
    private Button infoBoldCheckbox;
    private Button infoItalicCheckbox;
    private ColorSelector warnColorButton;
    private Button warnBoldCheckbox;
    private Button warnItalicCheckbox;
    private ColorSelector errorColorButton;
    private Button errorBoldCheckbox;
    private Button errorItalicCheckbox;
    private ColorSelector fatalColorButton;
    private Button fatalBoldCheckbox;
    private Button fatalItalicCheckbox;

    public ColorsAndFontsPage() {
        super("Colors and Fonts");
        this.setPreferenceStore(ApacheDsPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Group consoleGroup = new Group(composite, 0);
        consoleGroup.setText("Console");
        GridLayout consoleGroupLayout = new GridLayout(4, false);
        consoleGroup.setLayout((Layout)consoleGroupLayout);
        consoleGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Label debugLabel = new Label((Composite)consoleGroup, 0);
        debugLabel.setText("Debug:");
        this.debugColorButton = new ColorSelector((Composite)consoleGroup);
        this.debugColorButton.getButton().setLayoutData((Object)new GridData(131072, 0, true, false));
        this.debugBoldCheckbox = new Button((Composite)consoleGroup, 32);
        this.debugBoldCheckbox.setText("Bold");
        this.debugItalicCheckbox = new Button((Composite)consoleGroup, 32);
        this.debugItalicCheckbox.setText("Italic");
        Label infoLabel = new Label((Composite)consoleGroup, 0);
        infoLabel.setText("Info:");
        this.infoColorButton = new ColorSelector((Composite)consoleGroup);
        this.infoColorButton.getButton().setLayoutData((Object)new GridData(131072, 0, true, false));
        this.infoBoldCheckbox = new Button((Composite)consoleGroup, 32);
        this.infoBoldCheckbox.setText("Bold");
        this.infoItalicCheckbox = new Button((Composite)consoleGroup, 32);
        this.infoItalicCheckbox.setText("Italic");
        Label warnLabel = new Label((Composite)consoleGroup, 0);
        warnLabel.setText("Warn:");
        this.warnColorButton = new ColorSelector((Composite)consoleGroup);
        this.warnColorButton.getButton().setLayoutData((Object)new GridData(131072, 0, true, false));
        this.warnBoldCheckbox = new Button((Composite)consoleGroup, 32);
        this.warnBoldCheckbox.setText("Bold");
        this.warnItalicCheckbox = new Button((Composite)consoleGroup, 32);
        this.warnItalicCheckbox.setText("Italic");
        Label errorLabel = new Label((Composite)consoleGroup, 0);
        errorLabel.setText("Error:");
        this.errorColorButton = new ColorSelector((Composite)consoleGroup);
        this.errorColorButton.getButton().setLayoutData((Object)new GridData(131072, 0, true, false));
        this.errorBoldCheckbox = new Button((Composite)consoleGroup, 32);
        this.errorBoldCheckbox.setText("Bold");
        this.errorItalicCheckbox = new Button((Composite)consoleGroup, 32);
        this.errorItalicCheckbox.setText("Italic");
        Label fatalLabel = new Label((Composite)consoleGroup, 0);
        fatalLabel.setText("Fatal:");
        this.fatalColorButton = new ColorSelector((Composite)consoleGroup);
        this.fatalColorButton.getButton().setLayoutData((Object)new GridData(131072, 0, true, false));
        this.fatalBoldCheckbox = new Button((Composite)consoleGroup, 32);
        this.fatalBoldCheckbox.setText("Bold");
        this.fatalItalicCheckbox = new Button((Composite)consoleGroup, 32);
        this.fatalItalicCheckbox.setText("Italic");
        this.initFromPreferences();
        this.applyDialogFont(composite);
        return composite;
    }

    private void initFromPreferences() {
        FontData[] fontDatas = PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.debugFont");
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.debugColor");
        this.setDebug(fontDatas, rgb);
        fontDatas = PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.infoFont");
        rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.infoColor");
        this.setInfo(fontDatas, rgb);
        fontDatas = PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.warnFont");
        rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.warnColor");
        this.setWarn(fontDatas, rgb);
        fontDatas = PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.errorFont");
        rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.errorColor");
        this.setError(fontDatas, rgb);
        fontDatas = PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.fatalFont");
        rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.fatalColor");
        this.setFatal(fontDatas, rgb);
    }

    protected void performDefaults() {
        FontData[] fontDatas = PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.debugFont");
        RGB rgb = PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.debugColor");
        this.setDebug(fontDatas, rgb);
        fontDatas = PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.infoFont");
        rgb = PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.infoColor");
        this.setInfo(fontDatas, rgb);
        fontDatas = PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.warnFont");
        rgb = PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.warnColor");
        this.setWarn(fontDatas, rgb);
        fontDatas = PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.errorFont");
        rgb = PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.errorColor");
        this.setError(fontDatas, rgb);
        fontDatas = PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.fatalFont");
        rgb = PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.fatalColor");
        this.setFatal(fontDatas, rgb);
        super.performDefaults();
    }

    public boolean performOk() {
        FontData[] fontDatas = PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.debugFont");
        this.setFontData(fontDatas, this.debugBoldCheckbox, this.debugItalicCheckbox);
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.debugFont", (FontData[])fontDatas);
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.debugColor", (RGB)this.debugColorButton.getColorValue());
        fontDatas = PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.infoFont");
        this.setFontData(fontDatas, this.infoBoldCheckbox, this.infoItalicCheckbox);
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.infoFont", (FontData[])fontDatas);
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.infoColor", (RGB)this.infoColorButton.getColorValue());
        fontDatas = PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.warnFont");
        this.setFontData(fontDatas, this.warnBoldCheckbox, this.warnItalicCheckbox);
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.warnFont", (FontData[])fontDatas);
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.warnColor", (RGB)this.warnColorButton.getColorValue());
        fontDatas = PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.errorFont");
        this.setFontData(fontDatas, this.errorBoldCheckbox, this.errorItalicCheckbox);
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.errorFont", (FontData[])fontDatas);
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.errorColor", (RGB)this.errorColorButton.getColorValue());
        fontDatas = PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.fatalFont");
        this.setFontData(fontDatas, this.fatalBoldCheckbox, this.fatalItalicCheckbox);
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.fatalFont", (FontData[])fontDatas);
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"prefs.colorAndFonts.fatalColor", (RGB)this.fatalColorButton.getColorValue());
        return super.performOk();
    }

    private void setDebug(FontData[] fontDatas, RGB rgb) {
        boolean bold = PreferenceStoreUtils.isBold(fontDatas);
        boolean italic = PreferenceStoreUtils.isItalic(fontDatas);
        this.debugColorButton.setColorValue(rgb);
        this.debugBoldCheckbox.setSelection(bold);
        this.debugItalicCheckbox.setSelection(italic);
    }

    private void setInfo(FontData[] fontDatas, RGB rgb) {
        boolean bold = PreferenceStoreUtils.isBold(fontDatas);
        boolean italic = PreferenceStoreUtils.isItalic(fontDatas);
        this.infoColorButton.setColorValue(rgb);
        this.infoBoldCheckbox.setSelection(bold);
        this.infoItalicCheckbox.setSelection(italic);
    }

    private void setWarn(FontData[] fontDatas, RGB rgb) {
        boolean bold = PreferenceStoreUtils.isBold(fontDatas);
        boolean italic = PreferenceStoreUtils.isItalic(fontDatas);
        this.warnColorButton.setColorValue(rgb);
        this.warnBoldCheckbox.setSelection(bold);
        this.warnItalicCheckbox.setSelection(italic);
    }

    private void setError(FontData[] fontDatas, RGB rgb) {
        boolean bold = PreferenceStoreUtils.isBold(fontDatas);
        boolean italic = PreferenceStoreUtils.isItalic(fontDatas);
        this.errorColorButton.setColorValue(rgb);
        this.errorBoldCheckbox.setSelection(bold);
        this.errorItalicCheckbox.setSelection(italic);
    }

    private void setFatal(FontData[] fontDatas, RGB rgb) {
        boolean bold = PreferenceStoreUtils.isBold(fontDatas);
        boolean italic = PreferenceStoreUtils.isItalic(fontDatas);
        this.fatalColorButton.setColorValue(rgb);
        this.fatalBoldCheckbox.setSelection(bold);
        this.fatalItalicCheckbox.setSelection(italic);
    }

    private void setFontData(FontData[] fontDatas, Button boldButton, Button italicButton) {
        for (FontData fontData : fontDatas) {
            int style = 0;
            if (boldButton.getSelection()) {
                style |= 1;
            }
            if (italicButton.getSelection()) {
                style |= 2;
            }
            fontData.setStyle(style);
        }
    }

    public void init(IWorkbench workbench) {
    }
}

